/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.conversations.v1.conversation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.sdk.converter.DateConverter;
import com.twilio.sdk.creator.conversations.v1.conversation.ParticipantCreator;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.conversations.v1.conversation.ParticipantFetcher;
import com.twilio.sdk.reader.conversations.v1.conversation.ParticipantReader;
import com.twilio.sdk.resource.SidResource;
import com.twilio.sdk.type.PhoneNumber;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Participant
extends SidResource {
    private static final long serialVersionUID = 234988862687153L;
    private final String sid;
    private final String address;
    private final Status status;
    private final String conversationSid;
    private final DateTime dateCreated;
    private final DateTime startTime;
    private final DateTime endTime;
    private final Integer duration;
    private final String accountSid;
    private final URI url;

    public static ParticipantReader read(String conversationSid) {
        return new ParticipantReader(conversationSid);
    }

    public static ParticipantCreator create(String conversationSid, PhoneNumber to, PhoneNumber from) {
        return new ParticipantCreator(conversationSid, to, from);
    }

    public static ParticipantFetcher fetch(String conversationSid, String sid) {
        return new ParticipantFetcher(conversationSid, sid);
    }

    public static Participant fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Participant)objectMapper.readValue(json, Participant.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Participant fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Participant)objectMapper.readValue(json, Participant.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Participant(@JsonProperty(value="sid") String sid, @JsonProperty(value="address") String address, @JsonProperty(value="status") Status status, @JsonProperty(value="conversation_sid") String conversationSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="start_time") String startTime, @JsonProperty(value="end_time") String endTime, @JsonProperty(value="duration") Integer duration, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.address = address;
        this.status = status;
        this.conversationSid = conversationSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.startTime = DateConverter.iso8601DateTimeFromString(startTime);
        this.endTime = DateConverter.iso8601DateTimeFromString(endTime);
        this.duration = duration;
        this.accountSid = accountSid;
        this.url = url;
    }

    @Override
    public final String getSid() {
        return this.sid;
    }

    public final String getAddress() {
        return this.address;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final String getConversationSid() {
        return this.conversationSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getStartTime() {
        return this.startTime;
    }

    public final DateTime getEndTime() {
        return this.endTime;
    }

    public final Integer getDuration() {
        return this.duration;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Participant other = (Participant)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.address, other.address) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.conversationSid, other.conversationSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.startTime, other.startTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.duration, other.duration) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.address, this.status, this.conversationSid, this.dateCreated, this.startTime, this.endTime, this.duration, this.accountSid, this.url});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("address", (Object)this.address).add("status", (Object)this.status).add("conversationSid", (Object)this.conversationSid).add("dateCreated", (Object)this.dateCreated).add("startTime", (Object)this.startTime).add("endTime", (Object)this.endTime).add("duration", (Object)this.duration).add("accountSid", (Object)this.accountSid).add("url", (Object)this.url).toString();
    }

    public static enum Status {
        CREATED("created"),
        CONNECTING("connecting"),
        CONNECTED("connected"),
        DISCONNECTED("disconnected"),
        FAILED("failed");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            String normalized = value.replace("-", "_").toUpperCase();
            try {
                return Status.valueOf(normalized);
            }
            catch (RuntimeException e) {
                return null;
            }
        }
    }
}

