/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.api.v2010.account.conference;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.sdk.converter.DateConverter;
import com.twilio.sdk.deleter.api.v2010.account.conference.ParticipantDeleter;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.api.v2010.account.conference.ParticipantFetcher;
import com.twilio.sdk.reader.api.v2010.account.conference.ParticipantReader;
import com.twilio.sdk.resource.SidResource;
import com.twilio.sdk.updater.api.v2010.account.conference.ParticipantUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Participant
extends SidResource {
    private static final long serialVersionUID = 238358972354024L;
    private final String accountSid;
    private final String callSid;
    private final String conferenceSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final Boolean endConferenceOnExit;
    private final Boolean muted;
    private final Boolean startConferenceOnEnter;
    private final String uri;

    public static ParticipantFetcher fetch(String accountSid, String conferenceSid, String callSid) {
        return new ParticipantFetcher(accountSid, conferenceSid, callSid);
    }

    public static ParticipantUpdater update(String accountSid, String conferenceSid, String callSid, Boolean muted) {
        return new ParticipantUpdater(accountSid, conferenceSid, callSid, muted);
    }

    public static ParticipantDeleter delete(String accountSid, String conferenceSid, String callSid) {
        return new ParticipantDeleter(accountSid, conferenceSid, callSid);
    }

    public static ParticipantReader read(String accountSid, String conferenceSid) {
        return new ParticipantReader(accountSid, conferenceSid);
    }

    public static Participant fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Participant)objectMapper.readValue(json, Participant.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Participant fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Participant)objectMapper.readValue(json, Participant.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Participant(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="call_sid") String callSid, @JsonProperty(value="conference_sid") String conferenceSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="end_conference_on_exit") Boolean endConferenceOnExit, @JsonProperty(value="muted") Boolean muted, @JsonProperty(value="start_conference_on_enter") Boolean startConferenceOnEnter, @JsonProperty(value="uri") String uri) {
        this.accountSid = accountSid;
        this.callSid = callSid;
        this.conferenceSid = conferenceSid;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.endConferenceOnExit = endConferenceOnExit;
        this.muted = muted;
        this.startConferenceOnEnter = startConferenceOnEnter;
        this.uri = uri;
    }

    @Override
    public final String getSid() {
        return this.getCallSid();
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getCallSid() {
        return this.callSid;
    }

    public final String getConferenceSid() {
        return this.conferenceSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final Boolean getEndConferenceOnExit() {
        return this.endConferenceOnExit;
    }

    public final Boolean getMuted() {
        return this.muted;
    }

    public final Boolean getStartConferenceOnEnter() {
        return this.startConferenceOnEnter;
    }

    public final String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Participant other = (Participant)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.callSid, other.callSid) && Objects.equals(this.conferenceSid, other.conferenceSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.endConferenceOnExit, other.endConferenceOnExit) && Objects.equals(this.muted, other.muted) && Objects.equals(this.startConferenceOnEnter, other.startConferenceOnEnter) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.callSid, this.conferenceSid, this.dateCreated, this.dateUpdated, this.endConferenceOnExit, this.muted, this.startConferenceOnEnter, this.uri);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("callSid", (Object)this.callSid).add("conferenceSid", (Object)this.conferenceSid).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("endConferenceOnExit", (Object)this.endConferenceOnExit).add("muted", (Object)this.muted).add("startConferenceOnEnter", (Object)this.startConferenceOnEnter).add("uri", (Object)this.uri).toString();
    }
}

