/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource;

import com.google.common.base.Strings;
import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.exception.InvalidRequestException;
import com.twilio.sdk.reader.Reader;
import com.twilio.sdk.resource.Page;
import com.twilio.sdk.resource.Resource;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ResourceSet<E extends Resource>
implements Iterable<E> {
    private final Reader<E> reader;
    private final TwilioRestClient client;
    private boolean autoPaging;
    private Page<E> page;
    private Iterator<E> iterator;

    public ResourceSet(Reader<E> reader, TwilioRestClient client, Page<E> page) {
        this.reader = reader;
        this.client = client;
        this.page = page;
        this.iterator = page.getRecords().iterator();
        this.autoPaging = true;
    }

    public boolean isAutoPaging() {
        return this.autoPaging;
    }

    public ResourceSet setAutoPaging(boolean autoPaging) {
        this.autoPaging = autoPaging;
        return this;
    }

    public int getPageSize() {
        return this.page.getPageSize();
    }

    public ResourceSet setPageSize(int pageSize) {
        this.reader.pageSize(pageSize);
        return this;
    }

    @Override
    public Iterator<E> iterator() {
        return new ResourceSetIterator(this);
    }

    private void fetchNextPage() {
        if (Strings.isNullOrEmpty((String)this.page.getNextPageUri())) {
            return;
        }
        this.page = this.reader.nextPage(this.page, this.client);
        this.iterator = this.page.getRecords().iterator();
    }

    private class ResourceSetIterator<E extends Resource>
    implements Iterator<E> {
        private final ResourceSet<E> resourceSet;

        public ResourceSetIterator(ResourceSet<E> resourceSet2) {
            this.resourceSet = resourceSet2;
        }

        @Override
        public boolean hasNext() {
            return ((ResourceSet)this.resourceSet).iterator.hasNext();
        }

        @Override
        public E next() {
            if (this.resourceSet == null || ((ResourceSet)this.resourceSet).iterator == null) {
                throw new NoSuchElementException();
            }
            Resource element = (Resource)((ResourceSet)this.resourceSet).iterator.next();
            if (this.resourceSet.isAutoPaging() && !((ResourceSet)this.resourceSet).iterator.hasNext()) {
                try {
                    ((ResourceSet)this.resourceSet).fetchNextPage();
                }
                catch (ApiConnectionException | ApiException | InvalidRequestException e) {
                    throw new RuntimeException(e);
                }
            }
            return (E)element;
        }

        @Override
        public void remove() {
            if (((ResourceSet)this.resourceSet).iterator != null) {
                ((ResourceSet)this.resourceSet).iterator.remove();
            }
        }
    }
}

