/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.reader.preview.wireless;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.reader.Reader;
import com.twilio.sdk.resource.Page;
import com.twilio.sdk.resource.ResourceSet;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.preview.wireless.Command;

public class CommandReader
extends Reader<Command> {
    private String device;
    private String status;
    private String direction;

    public CommandReader byDevice(String device) {
        this.device = device;
        return this;
    }

    public CommandReader byStatus(String status) {
        this.status = status;
        return this;
    }

    public CommandReader byDirection(String direction) {
        this.direction = direction;
        return this;
    }

    @Override
    public ResourceSet<Command> execute(TwilioRestClient client) {
        return new ResourceSet<Command>(this, client, this.firstPage());
    }

    @Override
    public Page<Command> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.PREVIEW, "/wireless/Commands", client.getAccountSid());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Command> nextPage(Page<Command> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUri(), client.getAccountSid());
        return this.pageForRequest(client, request);
    }

    private Page<Command> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Command read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("commands", response.getContent(), Command.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.device != null) {
            request.addQueryParam("Device", this.device);
        }
        if (this.status != null) {
            request.addQueryParam("Status", this.status);
        }
        if (this.direction != null) {
            request.addQueryParam("Direction", this.direction);
        }
        request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
    }
}

