/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.reader.notifications.v1.service;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.converter.Promoter;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.reader.Reader;
import com.twilio.sdk.resource.Page;
import com.twilio.sdk.resource.ResourceSet;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.notifications.v1.service.Binding;
import java.util.List;

public class BindingReader
extends Reader<Binding> {
    private final String serviceSid;
    private String startDate;
    private String endDate;
    private List<String> identity;
    private List<String> tag;

    public BindingReader(String serviceSid) {
        this.serviceSid = serviceSid;
    }

    public BindingReader byStartDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    public BindingReader byEndDate(String endDate) {
        this.endDate = endDate;
        return this;
    }

    public BindingReader byIdentity(List<String> identity) {
        this.identity = identity;
        return this;
    }

    public BindingReader byIdentity(String identity) {
        return this.byIdentity(Promoter.listOfOne(identity));
    }

    public BindingReader byTag(List<String> tag) {
        this.tag = tag;
        return this;
    }

    public BindingReader byTag(String tag) {
        return this.byTag(Promoter.listOfOne(tag));
    }

    @Override
    public ResourceSet<Binding> execute(TwilioRestClient client) {
        return new ResourceSet<Binding>(this, client, this.firstPage());
    }

    @Override
    public Page<Binding> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.NOTIFICATIONS, "/v1/Services/" + this.serviceSid + "/Bindings", client.getAccountSid());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Binding> nextPage(Page<Binding> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUri(), client.getAccountSid());
        return this.pageForRequest(client, request);
    }

    private Page<Binding> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Binding read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("bindings", response.getContent(), Binding.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.startDate != null) {
            request.addQueryParam("StartDate", this.startDate);
        }
        if (this.endDate != null) {
            request.addQueryParam("EndDate", this.endDate);
        }
        if (this.identity != null) {
            request.addQueryParam("Identity", this.identity.toString());
        }
        if (this.tag != null) {
            request.addQueryParam("Tag", this.tag.toString());
        }
        request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
    }
}

