/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.reader.ipmessaging.v1.service;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.reader.Reader;
import com.twilio.sdk.resource.Page;
import com.twilio.sdk.resource.ResourceSet;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.ipmessaging.v1.service.Channel;

public class ChannelReader
extends Reader<Channel> {
    private final String serviceSid;

    public ChannelReader(String serviceSid) {
        this.serviceSid = serviceSid;
    }

    @Override
    public ResourceSet<Channel> execute(TwilioRestClient client) {
        return new ResourceSet<Channel>(this, client, this.firstPage());
    }

    @Override
    public Page<Channel> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.IPMESSAGING, "/v1/Services/" + this.serviceSid + "/Channels", client.getAccountSid());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Channel> nextPage(Page<Channel> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUri(), client.getAccountSid());
        return this.pageForRequest(client, request);
    }

    private Page<Channel> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Channel read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("channels", response.getContent(), Channel.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
    }
}

