/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.reader.conversations.v1.conversation;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.reader.Reader;
import com.twilio.sdk.resource.Page;
import com.twilio.sdk.resource.ResourceSet;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.conversations.v1.conversation.InProgress;

public class InProgressReader
extends Reader<InProgress> {
    @Override
    public ResourceSet<InProgress> execute(TwilioRestClient client) {
        return new ResourceSet<InProgress>(this, client, this.firstPage());
    }

    @Override
    public Page<InProgress> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.CONVERSATIONS, "/v1/Conversations/InProgress", client.getAccountSid());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<InProgress> nextPage(Page<InProgress> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUri(), client.getAccountSid());
        return this.pageForRequest(client, request);
    }

    private Page<InProgress> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("InProgress read failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 200) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("conversations", response.getContent(), InProgress.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
    }
}

