/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.reader.api.v2010.account;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.reader.Reader;
import com.twilio.sdk.resource.Page;
import com.twilio.sdk.resource.ResourceSet;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.api.v2010.account.Queue;

public class QueueReader
extends Reader<Queue> {
    private final String accountSid;

    public QueueReader(String accountSid) {
        this.accountSid = accountSid;
    }

    @Override
    public ResourceSet<Queue> execute(TwilioRestClient client) {
        return new ResourceSet<Queue>(this, client, this.firstPage());
    }

    @Override
    public Page<Queue> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.API, "/2010-04-01/Accounts/" + this.accountSid + "/Queues.json", client.getAccountSid());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Queue> nextPage(Page<Queue> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUri(), client.getAccountSid());
        return this.pageForRequest(client, request);
    }

    private Page<Queue> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Queue read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("queues", response.getContent(), Queue.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
    }
}

