/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.fetcher.pricing.v1.messaging;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.Fetcher;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.pricing.v1.messaging.Country;

public class CountryFetcher
extends Fetcher<Country> {
    private final String isoCountry;

    public CountryFetcher(String isoCountry) {
        this.isoCountry = isoCountry;
    }

    @Override
    public Country execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.PRICING, "/v1/Messaging/Countries/" + this.isoCountry + "", client.getAccountSid());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Country fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Country.fromJson(response.getStream(), client.getObjectMapper());
    }
}

