/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.fetcher.monitor.v1;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.Fetcher;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.monitor.v1.Alert;

public class AlertFetcher
extends Fetcher<Alert> {
    private final String sid;

    public AlertFetcher(String sid) {
        this.sid = sid;
    }

    @Override
    public Alert execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.MONITOR, "/v1/Alerts/" + this.sid + "", client.getAccountSid());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Alert fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Alert.fromJson(response.getStream(), client.getObjectMapper());
    }
}

