/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.creator.taskrouter.v1.workspace;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.creator.Creator;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.taskrouter.v1.workspace.Workflow;

public class WorkflowCreator
extends Creator<Workflow> {
    private final String workspaceSid;
    private final String friendlyName;
    private final String configuration;
    private final String assignmentCallbackUrl;
    private String fallbackAssignmentCallbackUrl;
    private Integer taskReservationTimeout;

    public WorkflowCreator(String workspaceSid, String friendlyName, String configuration, String assignmentCallbackUrl) {
        this.workspaceSid = workspaceSid;
        this.friendlyName = friendlyName;
        this.configuration = configuration;
        this.assignmentCallbackUrl = assignmentCallbackUrl;
    }

    public WorkflowCreator setFallbackAssignmentCallbackUrl(String fallbackAssignmentCallbackUrl) {
        this.fallbackAssignmentCallbackUrl = fallbackAssignmentCallbackUrl;
        return this;
    }

    public WorkflowCreator setTaskReservationTimeout(Integer taskReservationTimeout) {
        this.taskReservationTimeout = taskReservationTimeout;
        return this;
    }

    @Override
    public Workflow execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, TwilioRestClient.Domains.TASKROUTER, "/v1/Workspaces/" + this.workspaceSid + "/Workflows", client.getAccountSid());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Workflow creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Workflow.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.configuration != null) {
            request.addPostParam("Configuration", this.configuration);
        }
        if (this.assignmentCallbackUrl != null) {
            request.addPostParam("AssignmentCallbackUrl", this.assignmentCallbackUrl);
        }
        if (this.fallbackAssignmentCallbackUrl != null) {
            request.addPostParam("FallbackAssignmentCallbackUrl", this.fallbackAssignmentCallbackUrl);
        }
        if (this.taskReservationTimeout != null) {
            request.addPostParam("TaskReservationTimeout", this.taskReservationTimeout.toString());
        }
    }
}

