/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.creator.taskrouter.v1.workspace;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.creator.Creator;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.taskrouter.v1.workspace.Task;

public class TaskCreator
extends Creator<Task> {
    private final String workspaceSid;
    private final String attributes;
    private final String workflowSid;
    private Integer timeout;
    private Integer priority;

    public TaskCreator(String workspaceSid, String attributes, String workflowSid) {
        this.workspaceSid = workspaceSid;
        this.attributes = attributes;
        this.workflowSid = workflowSid;
    }

    public TaskCreator setTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    public TaskCreator setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @Override
    public Task execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, TwilioRestClient.Domains.TASKROUTER, "/v1/Workspaces/" + this.workspaceSid + "/Tasks", client.getAccountSid());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Task creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Task.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.attributes != null) {
            request.addPostParam("Attributes", this.attributes);
        }
        if (this.workflowSid != null) {
            request.addPostParam("WorkflowSid", this.workflowSid);
        }
        if (this.timeout != null) {
            request.addPostParam("Timeout", this.timeout.toString());
        }
        if (this.priority != null) {
            request.addPostParam("Priority", this.priority.toString());
        }
    }
}

