/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.creator.preview.wireless;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.converter.Promoter;
import com.twilio.sdk.creator.Creator;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.preview.wireless.Command;
import java.net.URI;

public class CommandCreator
extends Creator<Command> {
    private final String device;
    private final String command;
    private String callbackMethod;
    private URI callbackUrl;

    public CommandCreator(String device, String command) {
        this.device = device;
        this.command = command;
    }

    public CommandCreator setCallbackMethod(String callbackMethod) {
        this.callbackMethod = callbackMethod;
        return this;
    }

    public CommandCreator setCallbackUrl(URI callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public CommandCreator setCallbackUrl(String callbackUrl) {
        return this.setCallbackUrl(Promoter.uriFromString(callbackUrl));
    }

    @Override
    public Command execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, TwilioRestClient.Domains.PREVIEW, "/wireless/Commands", client.getAccountSid());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Command creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Command.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.device != null) {
            request.addPostParam("Device", this.device);
        }
        if (this.command != null) {
            request.addPostParam("Command", this.command);
        }
        if (this.callbackMethod != null) {
            request.addPostParam("CallbackMethod", this.callbackMethod);
        }
        if (this.callbackUrl != null) {
            request.addPostParam("CallbackUrl", this.callbackUrl.toString());
        }
    }
}

