/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.creator.api.v2010.account.incomingphonenumber;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.converter.Promoter;
import com.twilio.sdk.creator.Creator;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.api.v2010.account.incomingphonenumber.Local;
import com.twilio.sdk.type.PhoneNumber;
import java.net.URI;

public class LocalCreator
extends Creator<Local> {
    private final String ownerAccountSid;
    private final PhoneNumber phoneNumber;
    private String apiVersion;
    private String friendlyName;
    private String smsApplicationSid;
    private HttpMethod smsFallbackMethod;
    private URI smsFallbackUrl;
    private HttpMethod smsMethod;
    private URI smsUrl;
    private URI statusCallback;
    private HttpMethod statusCallbackMethod;
    private String voiceApplicationSid;
    private Boolean voiceCallerIdLookup;
    private HttpMethod voiceFallbackMethod;
    private URI voiceFallbackUrl;
    private HttpMethod voiceMethod;
    private URI voiceUrl;

    public LocalCreator(String ownerAccountSid, PhoneNumber phoneNumber) {
        this.ownerAccountSid = ownerAccountSid;
        this.phoneNumber = phoneNumber;
    }

    public LocalCreator setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public LocalCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public LocalCreator setSmsApplicationSid(String smsApplicationSid) {
        this.smsApplicationSid = smsApplicationSid;
        return this;
    }

    public LocalCreator setSmsFallbackMethod(HttpMethod smsFallbackMethod) {
        this.smsFallbackMethod = smsFallbackMethod;
        return this;
    }

    public LocalCreator setSmsFallbackUrl(URI smsFallbackUrl) {
        this.smsFallbackUrl = smsFallbackUrl;
        return this;
    }

    public LocalCreator setSmsFallbackUrl(String smsFallbackUrl) {
        return this.setSmsFallbackUrl(Promoter.uriFromString(smsFallbackUrl));
    }

    public LocalCreator setSmsMethod(HttpMethod smsMethod) {
        this.smsMethod = smsMethod;
        return this;
    }

    public LocalCreator setSmsUrl(URI smsUrl) {
        this.smsUrl = smsUrl;
        return this;
    }

    public LocalCreator setSmsUrl(String smsUrl) {
        return this.setSmsUrl(Promoter.uriFromString(smsUrl));
    }

    public LocalCreator setStatusCallback(URI statusCallback) {
        this.statusCallback = statusCallback;
        return this;
    }

    public LocalCreator setStatusCallback(String statusCallback) {
        return this.setStatusCallback(Promoter.uriFromString(statusCallback));
    }

    public LocalCreator setStatusCallbackMethod(HttpMethod statusCallbackMethod) {
        this.statusCallbackMethod = statusCallbackMethod;
        return this;
    }

    public LocalCreator setVoiceApplicationSid(String voiceApplicationSid) {
        this.voiceApplicationSid = voiceApplicationSid;
        return this;
    }

    public LocalCreator setVoiceCallerIdLookup(Boolean voiceCallerIdLookup) {
        this.voiceCallerIdLookup = voiceCallerIdLookup;
        return this;
    }

    public LocalCreator setVoiceFallbackMethod(HttpMethod voiceFallbackMethod) {
        this.voiceFallbackMethod = voiceFallbackMethod;
        return this;
    }

    public LocalCreator setVoiceFallbackUrl(URI voiceFallbackUrl) {
        this.voiceFallbackUrl = voiceFallbackUrl;
        return this;
    }

    public LocalCreator setVoiceFallbackUrl(String voiceFallbackUrl) {
        return this.setVoiceFallbackUrl(Promoter.uriFromString(voiceFallbackUrl));
    }

    public LocalCreator setVoiceMethod(HttpMethod voiceMethod) {
        this.voiceMethod = voiceMethod;
        return this;
    }

    public LocalCreator setVoiceUrl(URI voiceUrl) {
        this.voiceUrl = voiceUrl;
        return this;
    }

    public LocalCreator setVoiceUrl(String voiceUrl) {
        return this.setVoiceUrl(Promoter.uriFromString(voiceUrl));
    }

    @Override
    public Local execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, TwilioRestClient.Domains.API, "/2010-04-01/Accounts/" + this.ownerAccountSid + "/IncomingPhoneNumbers/Local.json", client.getAccountSid());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Local creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Local.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.phoneNumber != null) {
            request.addPostParam("PhoneNumber", this.phoneNumber.toString());
        }
        if (this.apiVersion != null) {
            request.addPostParam("ApiVersion", this.apiVersion);
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.smsApplicationSid != null) {
            request.addPostParam("SmsApplicationSid", this.smsApplicationSid);
        }
        if (this.smsFallbackMethod != null) {
            request.addPostParam("SmsFallbackMethod", this.smsFallbackMethod.toString());
        }
        if (this.smsFallbackUrl != null) {
            request.addPostParam("SmsFallbackUrl", this.smsFallbackUrl.toString());
        }
        if (this.smsMethod != null) {
            request.addPostParam("SmsMethod", this.smsMethod.toString());
        }
        if (this.smsUrl != null) {
            request.addPostParam("SmsUrl", this.smsUrl.toString());
        }
        if (this.statusCallback != null) {
            request.addPostParam("StatusCallback", this.statusCallback.toString());
        }
        if (this.statusCallbackMethod != null) {
            request.addPostParam("StatusCallbackMethod", this.statusCallbackMethod.toString());
        }
        if (this.voiceApplicationSid != null) {
            request.addPostParam("VoiceApplicationSid", this.voiceApplicationSid);
        }
        if (this.voiceCallerIdLookup != null) {
            request.addPostParam("VoiceCallerIdLookup", this.voiceCallerIdLookup.toString());
        }
        if (this.voiceFallbackMethod != null) {
            request.addPostParam("VoiceFallbackMethod", this.voiceFallbackMethod.toString());
        }
        if (this.voiceFallbackUrl != null) {
            request.addPostParam("VoiceFallbackUrl", this.voiceFallbackUrl.toString());
        }
        if (this.voiceMethod != null) {
            request.addPostParam("VoiceMethod", this.voiceMethod.toString());
        }
        if (this.voiceUrl != null) {
            request.addPostParam("VoiceUrl", this.voiceUrl.toString());
        }
    }
}

