/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.creator.api.v2010.account;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.converter.Promoter;
import com.twilio.sdk.creator.Creator;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.api.v2010.account.Message;
import com.twilio.sdk.type.PhoneNumber;
import java.net.URI;
import java.util.List;

public class MessageCreator
extends Creator<Message> {
    private final String accountSid;
    private final PhoneNumber to;
    private final PhoneNumber from;
    private String body;
    private List<URI> mediaUrl;
    private URI statusCallback;
    private String applicationSid;
    private Boolean provideFeedback;

    public MessageCreator(String accountSid, PhoneNumber to, PhoneNumber from, String body) {
        this.accountSid = accountSid;
        this.to = to;
        this.from = from;
        this.body = body;
    }

    public MessageCreator(String accountSid, PhoneNumber to, PhoneNumber from, List<URI> mediaUrl) {
        this.accountSid = accountSid;
        this.to = to;
        this.from = from;
        this.mediaUrl = mediaUrl;
    }

    public MessageCreator setStatusCallback(URI statusCallback) {
        this.statusCallback = statusCallback;
        return this;
    }

    public MessageCreator setStatusCallback(String statusCallback) {
        return this.setStatusCallback(Promoter.uriFromString(statusCallback));
    }

    public MessageCreator setApplicationSid(String applicationSid) {
        this.applicationSid = applicationSid;
        return this;
    }

    public MessageCreator setProvideFeedback(Boolean provideFeedback) {
        this.provideFeedback = provideFeedback;
        return this;
    }

    @Override
    public Message execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, TwilioRestClient.Domains.API, "/2010-04-01/Accounts/" + this.accountSid + "/Messages.json", client.getAccountSid());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Message creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Message.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.to != null) {
            request.addPostParam("To", this.to.toString());
        }
        if (this.from != null) {
            request.addPostParam("From", this.from.toString());
        }
        if (this.body != null) {
            request.addPostParam("Body", this.body);
        }
        if (this.mediaUrl != null) {
            for (URI prop : this.mediaUrl) {
                request.addPostParam("MediaUrl", ((Object)prop).toString());
            }
        }
        if (this.statusCallback != null) {
            request.addPostParam("StatusCallback", this.statusCallback.toString());
        }
        if (this.applicationSid != null) {
            request.addPostParam("ApplicationSid", this.applicationSid);
        }
        if (this.provideFeedback != null) {
            request.addPostParam("ProvideFeedback", this.provideFeedback.toString());
        }
    }
}

