/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.taskrouter;

import com.twilio.sdk.taskrouter.FilterRequirement;
import com.twilio.sdk.taskrouter.Policy;
import com.twilio.sdk.taskrouter.TaskRouterCapability;

public class TaskRouterWorkerCapability
extends TaskRouterCapability {
    private final String tasksUrl;
    private final String activityUrl;
    private final String workerReservationsUrl;

    public TaskRouterWorkerCapability(String accountSid, String authToken, String workspaceSid, String workerSid) {
        super(accountSid, authToken, workspaceSid, workerSid);
        this.tasksUrl = this.baseUrl + "/Tasks/**";
        this.activityUrl = this.baseUrl + "/Activities";
        this.workerReservationsUrl = this.resourceUrl + "/Reservations/**";
        this.allow(this.activityUrl, "GET", null, null);
        this.allow(this.tasksUrl, "GET", null, null);
        this.allow(this.workerReservationsUrl, "GET", null, null);
    }

    @Override
    protected void setupResource() {
        this.resourceUrl = this.baseUrl + "/Workers/" + this.channelId;
    }

    public void allowActivityUpdates() {
        Policy policy = new Policy(this.resourceUrl, "POST", true);
        policy.postFilter.put("ActivitySid", FilterRequirement.REQUIRED);
        this.policies.add(policy);
    }

    public void allowReservationUpdates() {
        Policy tasksPolicy = new Policy(this.tasksUrl, "POST", true);
        Policy workerReservationsPolicy = new Policy(this.workerReservationsUrl, "POST", true);
        this.policies.add(tasksPolicy);
        this.policies.add(workerReservationsPolicy);
    }
}

