/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.taskrouter;

import com.twilio.sdk.TwilioTaskRouterClient;
import com.twilio.sdk.resource.NextGenInstanceResource;
import com.twilio.sdk.resource.instance.taskrouter.ActivityStatistic;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class WorkspaceStatistics
extends NextGenInstanceResource<TwilioTaskRouterClient> {
    private static final String CUMULATIVE_PROPERTY = "cumulative";
    private static final String REALTIME_PROPERTY = "realtime";
    private static final String TASKS_BY_STATUS_PROPERTY = "tasks_by_status";
    private static final String WORKSPACE_SID_PROPERTY = "workspace_sid";

    public WorkspaceStatistics(TwilioTaskRouterClient client, String workspaceSid) {
        this(client, workspaceSid, null);
    }

    public WorkspaceStatistics(TwilioTaskRouterClient client, String workspaceSid, Map<String, String> filters) {
        super(client);
        if (StringUtils.isBlank((CharSequence)workspaceSid)) {
            throw new IllegalArgumentException("The workspaceSid for a WorkspaceStatistics cannot be null");
        }
        this.setProperty(WORKSPACE_SID_PROPERTY, workspaceSid);
        this.filters = filters;
    }

    public Set<ActivityStatistic> getActivityStatistics() {
        try {
            List props = (List)this.getRealtime().get("activity_statistics");
            HashSet<ActivityStatistic> activityStatistics = new HashSet<ActivityStatistic>();
            for (Map prop : props) {
                ActivityStatistic activityStatistic = this.mapToActivityStatistic(prop);
                activityStatistics.add(activityStatistic);
            }
            return Collections.unmodifiableSet(activityStatistics);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Integer getAssignedTasks() {
        Map tasksByStatus = (Map)this.getRealtime().get(TASKS_BY_STATUS_PROPERTY);
        return (Integer)tasksByStatus.get("assigned");
    }

    public Double getAverageTaskAcceptanceTime() {
        try {
            Object prop = this.getCumulative().get("avg_task_acceptance_time");
            if (prop instanceof Integer) {
                return Double.parseDouble(prop.toString());
            }
            return (Double)prop;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Calendar getEndTime() {
        return this.parseCalendar((String)this.getCumulative().get("end_time"));
    }

    public Integer getLongestTaskWaitingAge() {
        return (Integer)this.getRealtime().get("longest_task_waiting_age");
    }

    public String getLongestTaskWaitingSid() {
        return (String)this.getRealtime().get("longest_task_waiting_sid");
    }

    public Integer getPendingTasks() {
        Map tasksByStatus = (Map)this.getRealtime().get(TASKS_BY_STATUS_PROPERTY);
        return (Integer)tasksByStatus.get("pending");
    }

    public Integer getReservationsAccepted() {
        return (Integer)this.getCumulative().get("reservations_accepted");
    }

    public Integer getReservationsRejected() {
        return (Integer)this.getCumulative().get("reservations_rejected");
    }

    public Integer getReservationsTimedOut() {
        return (Integer)this.getCumulative().get("reservations_timed_out");
    }

    public Integer getReservedTasks() {
        Map tasksByStatus = (Map)this.getRealtime().get(TASKS_BY_STATUS_PROPERTY);
        return (Integer)tasksByStatus.get("reserved");
    }

    public Calendar getStartTime() {
        return this.parseCalendar((String)this.getCumulative().get("start_time"));
    }

    public Integer getTasksCanceled() {
        return (Integer)this.getCumulative().get("tasks_canceled");
    }

    public Integer getTasksCreated() {
        return (Integer)this.getCumulative().get("tasks_created");
    }

    public Integer getTasksMoved() {
        return (Integer)this.getCumulative().get("tasks_moved");
    }

    public Integer getTasksTimedOutInWorkflow() {
        return (Integer)this.getCumulative().get("tasks_timed_out_in_workflow");
    }

    public Integer getTotalTasks() {
        return (Integer)this.getRealtime().get("total_tasks");
    }

    public Integer getTotalWorkers() {
        return (Integer)this.getRealtime().get("total_workers");
    }

    public String getWorkspaceSid() {
        return this.getProperty(WORKSPACE_SID_PROPERTY);
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Workspaces/" + this.getWorkspaceSid() + "/Statistics";
    }

    private Map<String, Object> getCumulative() {
        return (Map)this.getObject(CUMULATIVE_PROPERTY);
    }

    private Map<String, Object> getRealtime() {
        return (Map)this.getObject(REALTIME_PROPERTY);
    }

    private ActivityStatistic mapToActivityStatistic(Map<String, Object> data) {
        Integer workers;
        String friendlyName;
        String sid;
        try {
            sid = (String)data.get("sid");
            friendlyName = (String)data.get("friendly_name");
            workers = (Integer)data.get("workers");
        }
        catch (Exception e) {
            throw new IllegalStateException("An Activity Statistic contained improperly formatted data.", e);
        }
        return new ActivityStatistic(sid, friendlyName, workers);
    }
}

