/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.pricing;

import com.twilio.sdk.TwilioPricingClient;
import com.twilio.sdk.resource.NextGenInstanceResource;
import com.twilio.sdk.resource.instance.pricing.NumberType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class VoiceCountry
extends NextGenInstanceResource<TwilioPricingClient> {
    public VoiceCountry(TwilioPricingClient client) {
        this(client, (Map<String, Object>)new HashMap<String, Object>());
    }

    public VoiceCountry(TwilioPricingClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    public VoiceCountry(TwilioPricingClient client, String isoCountry) {
        super(client);
        if (isoCountry == null || "".equals(isoCountry)) {
            throw new IllegalArgumentException("The isoCountry for a VoiceCountry cannot be null");
        }
        this.setProperty("iso_country", isoCountry);
    }

    public String getCountry() {
        return this.getProperty("country");
    }

    public String getIsoCountry() {
        return this.getProperty("iso_country");
    }

    public String getPriceUnit() {
        return this.getProperty("price_unit");
    }

    public List<InboundCallPrice> getInboundCallPrices() {
        List priceData = (List)this.getCastedObject("inbound_call_prices");
        ArrayList<InboundCallPrice> prices = new ArrayList<InboundCallPrice>();
        for (Map p : priceData) {
            prices.add(new InboundCallPrice(NumberType.valueOf(((String)p.get("number_type")).toUpperCase()), new BigDecimal((String)p.get("base_price")), new BigDecimal((String)p.get("current_price"))));
        }
        return prices;
    }

    public List<OutboundPrefixPrice> getOutboundPrefixPrices() {
        List priceData = (List)this.getCastedObject("outbound_prefix_prices");
        ArrayList<OutboundPrefixPrice> prices = new ArrayList<OutboundPrefixPrice>();
        for (Map p : priceData) {
            prices.add(new OutboundPrefixPrice((String)p.get("friendly_name"), new BigDecimal((String)p.get("base_price")), new BigDecimal((String)p.get("current_price")), (List)p.get("prefix_list")));
        }
        return prices;
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Voice/Countries/" + this.getIsoCountry();
    }

    public class InboundCallPrice {
        private final NumberType numberType;
        private final BigDecimal basePrice;
        private final BigDecimal currentPrice;

        public InboundCallPrice(NumberType numberType, BigDecimal basePrice, BigDecimal currentPrice) {
            this.numberType = numberType;
            this.basePrice = basePrice;
            this.currentPrice = currentPrice;
        }

        public NumberType getNumberType() {
            return this.numberType;
        }

        public BigDecimal getBasePrice() {
            return this.basePrice;
        }

        public BigDecimal getCurrentPrice() {
            return this.currentPrice;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InboundCallPrice that = (InboundCallPrice)o;
            return new EqualsBuilder().append((Object)this.basePrice, (Object)that.basePrice).append((Object)this.currentPrice, (Object)that.currentPrice).append((Object)this.numberType, (Object)that.numberType).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.numberType).append((Object)this.basePrice).append((Object)this.currentPrice).toHashCode();
        }
    }

    public class OutboundPrefixPrice {
        private final String friendlyName;
        private final BigDecimal basePrice;
        private final BigDecimal currentPrice;
        private final List<String> prefixes;

        public OutboundPrefixPrice(String friendlyName, BigDecimal basePrice, BigDecimal currentPrice, List<String> prefixes) {
            this.friendlyName = friendlyName;
            this.basePrice = basePrice;
            this.currentPrice = currentPrice;
            this.prefixes = prefixes;
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }

        public BigDecimal getBasePrice() {
            return this.basePrice;
        }

        public BigDecimal getCurrentPrice() {
            return this.currentPrice;
        }

        public List<String> getPrefixes() {
            return this.prefixes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OutboundPrefixPrice other = (OutboundPrefixPrice)o;
            return new EqualsBuilder().append((Object)this.friendlyName, (Object)other.friendlyName).append((Object)this.basePrice, (Object)other.basePrice).append((Object)this.currentPrice, (Object)other.currentPrice).append(this.prefixes, other.prefixes).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.friendlyName).append((Object)this.basePrice).append((Object)this.currentPrice).append(this.prefixes).toHashCode();
        }
    }
}

