/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.InstanceResource;
import java.util.Date;
import java.util.Map;

public class OutgoingCallerId
extends InstanceResource<TwilioRestClient> {
    public OutgoingCallerId(TwilioRestClient client) {
        super(client);
    }

    public OutgoingCallerId(TwilioRestClient client, String sid) {
        super(client);
        if (sid == null) {
            throw new IllegalStateException("The Sid for an OutgoingCallerId can not be null");
        }
        this.setProperty("sid", sid);
    }

    public OutgoingCallerId(TwilioRestClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    @Override
    protected String getResourceLocation() {
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/OutgoingCallerIds/" + this.getSid() + ".json";
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public Date getDateCreated() {
        return this.getDateProperty("date_created");
    }

    public Date getDateUpdated() {
        return this.getDateProperty("date_updated");
    }

    public String getFriendlyName() {
        return this.getProperty("friendly_name");
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getPhoneNumber() {
        return this.getProperty("phone_number");
    }

    public boolean delete() throws TwilioRestException {
        TwilioRestResponse response = ((TwilioRestClient)this.getClient()).safeRequest(this.getResourceLocation(), "DELETE", (Map<String, String>)null);
        return !response.isError();
    }
}

