/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.InstanceResource;
import java.util.Date;
import java.util.Map;

public class Media
extends InstanceResource<TwilioRestClient> {
    private static String requestMessageSid;

    public Media(TwilioRestClient client) {
        super(client);
    }

    public Media(TwilioRestClient client, String mediaSid) {
        super(client);
        if (mediaSid == null) {
            throw new IllegalStateException("The sid for a Media instance can not be null");
        }
        this.setProperty("sid", mediaSid);
    }

    public Media(TwilioRestClient client, String messageSid, String mediaSid) {
        super(client);
        requestMessageSid = messageSid;
        if (mediaSid == null) {
            throw new IllegalStateException("The sid for a Media instance can not be null");
        }
        this.setProperty("sid", mediaSid);
    }

    public Media(TwilioRestClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    @Override
    protected String getResourceLocation() {
        if (this.getRequestMessageSid() != null) {
            return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/Messages/" + this.getRequestMessageSid() + "/Media/" + this.getSid() + ".json";
        }
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/Media/" + this.getSid() + ".json";
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public String getRequestMessageSid() {
        return requestMessageSid;
    }

    public Date getDateCreated() {
        return this.parseDate(this.getProperty("date_created"));
    }

    public Date getDateUpdated() {
        return this.parseDate(this.getProperty("date_updated"));
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getParentSid() {
        return this.getProperty("parent_sid");
    }

    public String getContentType() {
        return this.getProperty("content_type");
    }

    public Integer getDuration() {
        Integer duration = (Integer)this.getObject("duration");
        if (duration != null) {
            return duration;
        }
        throw new IllegalStateException("The Media instance doesn't have the max size property set");
    }

    public String getApiVersion() {
        return this.getProperty("api_version");
    }

    public String getUri() {
        return this.getProperty("uri");
    }

    public boolean delete() throws TwilioRestException {
        TwilioRestResponse response = ((TwilioRestClient)this.getClient()).safeRequest(this.getResourceLocation(), "DELETE", (Map<String, String>)null);
        return !response.isError();
    }
}

