/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.InstanceResource;
import java.util.Date;
import java.util.Map;

public class Key
extends InstanceResource<TwilioRestClient> {
    public Key(TwilioRestClient client, String sid) {
        super(client);
        if (sid == null) {
            throw new IllegalArgumentException("sid for a Key cannot be null");
        }
        this.setProperty("sid", sid);
    }

    public Key(TwilioRestClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public Date getDateCreated() {
        return this.parseDate(this.getProperty("date_created"));
    }

    public Date getDateUpdated() {
        return this.parseDate(this.getProperty("date_updated"));
    }

    public String getFriendlyName() {
        return this.getProperty("friendly_name");
    }

    public String getSecret() {
        return this.getProperty("secret");
    }

    public boolean delete() throws TwilioRestException {
        TwilioRestResponse response = ((TwilioRestClient)this.getClient()).safeRequest(this.getResourceLocation(), "DELETE", (Map<String, String>)null);
        return !response.isError();
    }

    @Override
    protected String getResourceLocation() {
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/Keys/" + this.getSid() + ".json";
    }
}

