/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class TwilioUtils {
    protected String authToken;

    public TwilioUtils(String authToken) {
        this.authToken = authToken;
    }

    @Deprecated
    public TwilioUtils(String authToken, String accountSid) {
        this.authToken = authToken;
    }

    public boolean validateRequest(String expectedSignature, String url, Map<String, String> params) {
        String signature = null;
        signature = this.getValidationSignature(url, params);
        return TwilioUtils.secureCompare(signature, expectedSignature);
    }

    public String getValidationSignature(String url, Map<String, String> params) {
        SecretKeySpec signingKey = new SecretKeySpec(this.authToken.getBytes(), "HmacSHA1");
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signingKey);
            StringBuffer data = new StringBuffer(url);
            if (params != null) {
                ArrayList<String> sortedKeys = new ArrayList<String>(params.keySet());
                Collections.sort(sortedKeys);
                for (String s : sortedKeys) {
                    data.append(s);
                    String v = "";
                    if (params.get(s) != null) {
                        v = params.get(s);
                    }
                    data.append(v);
                }
            }
            byte[] rawHmac = mac.doFinal(data.toString().getBytes("UTF-8"));
            String signature = new String(Base64.encodeBase64((byte[])rawHmac));
            return signature;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        catch (InvalidKeyException e) {
            return null;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    static boolean secureCompare(String a, String b) {
        if (a == null || b == null) {
            return false;
        }
        int n = a.length();
        if (n != b.length()) {
            return false;
        }
        int mismatch = 0;
        for (int i = 0; i < n; ++i) {
            char chA = a.charAt(i);
            char chB = b.charAt(i);
            mismatch |= chA ^ chB;
        }
        return mismatch == 0;
    }
}

