/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk;

import com.twilio.sdk.TwilioRestResponse;
import java.util.Map;

public class TwilioRestException
extends Exception {
    private static final long serialVersionUID = -181355409302925081L;
    private int errorCode;
    private String message;
    private String moreInfo;

    public TwilioRestException(String message, int errorCode) {
        this(message, errorCode, "");
    }

    public TwilioRestException(String message, int errorCode, String moreInfo) {
        super(message);
        this.message = message;
        this.errorCode = errorCode;
        this.moreInfo = moreInfo;
    }

    public static TwilioRestException parseResponse(TwilioRestResponse response) {
        Map<String, Object> data = response.toMap();
        String message = "";
        String moreInfo = "";
        int errorCode = 0;
        if (response.isJson()) {
            message = (String)data.get("message");
            if (data.get("code") != null) {
                errorCode = (Integer)data.get("code");
            }
            if (data.get("more_info") != null) {
                moreInfo = (String)data.get("more_info");
            }
        }
        return new TwilioRestException(message, errorCode, moreInfo);
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.message;
    }

    public String getMoreInfo() {
        return this.moreInfo;
    }
}

