/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.verbs;

import com.twilio.sdk.verbs.Verb;

public class Conference
extends Verb {
    public static final String BEEP_TRUE = "true";
    public static final String BEEP_FALSE = "false";
    public static final String BEEP_ONEXIT = "onExit";
    public static final String BEEP_ONENTER = "onEnter";

    public Conference(String name) {
        super("Conference", name);
        this.allowedVerbs = null;
    }

    private void setBoolean(String attr, Boolean bool) {
        if (bool.booleanValue()) {
            this.set(attr, BEEP_TRUE);
        } else {
            this.set(attr, BEEP_FALSE);
        }
    }

    public void setMuted(Boolean bool) {
        this.setBoolean("muted", bool);
    }

    public void setBeep(String value) {
        this.set("beep", value);
    }

    public void setBeep(Boolean bool) {
        this.set("beep", bool.toString());
    }

    public void setStartConferenceOnEnter(Boolean bool) {
        this.setBoolean("startConferenceOnEnter", bool);
    }

    public void setEndConferenceOnExit(Boolean bool) {
        this.setBoolean("endConferenceOnExit", bool);
    }

    public void setWaitMethod(String method) {
        this.set("waitMethod", method);
    }

    public void setWaitUrl(String url) {
        this.set("waitUrl", url);
    }

    public void setMaxParticipants(int i) {
        this.set("maxParticipants", Integer.toString(i));
    }

    public void setRecord(Record record) {
        this.setRecord(record.toString());
    }

    public void setRecord(String record) {
        this.set("record", record);
    }

    public void setTrim(Trim trim) {
        this.setTrim(trim.toString());
    }

    public void setTrim(String trim) {
        this.set("trim", trim);
    }

    public void setEventCallbackUrl(String eventCallbackUrl) {
        this.set("eventCallbackUrl", eventCallbackUrl);
    }

    public static enum Trim {
        TRIM_SILENCE("trim-silence"),
        DO_NOT_TRIM("do-not-trim");

        private final String value;

        private Trim(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Record {
        DO_NOT_RECORD("do-not-record"),
        RECORD_FROM_START("record-from-start");

        private final String value;

        private Record(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

