/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.taskrouter;

import com.twilio.sdk.taskrouter.WorkflowRuleTarget;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class WorkflowRule {
    private String expression;
    private String friendlyName;
    private List<WorkflowRuleTarget> targets;

    public WorkflowRule(String expression, List<WorkflowRuleTarget> targets) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)expression)) {
            throw new IllegalArgumentException("Expression for Workflow Rule is required");
        }
        if (targets == null || targets.isEmpty()) {
            throw new IllegalArgumentException("Targets for Workflow Rule are required");
        }
        this.expression = expression;
        this.targets = targets;
    }

    @JsonCreator
    public WorkflowRule(@JsonProperty(value="expression") String expression, @JsonProperty(value="targets") List<WorkflowRuleTarget> targets, @JsonProperty(value="friendly_name") String friendlyName) throws IllegalArgumentException {
        this(expression, targets);
        this.friendlyName = friendlyName;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    @JsonIgnore
    public List<WorkflowRuleTarget> getWorkflowRuleTargets() {
        return this.targets;
    }

    public void setWorkflowRuleTargets(List<WorkflowRuleTarget> targets) {
        this.targets = targets;
    }

    public void addWorkflowRuleTarget(WorkflowRuleTarget target) {
        this.targets.add(target);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

