/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.taskrouter;

import com.twilio.sdk.taskrouter.WorkflowRule;
import com.twilio.sdk.taskrouter.WorkflowRuleTarget;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class WorkflowConfiguration {
    @JsonProperty(value="task_routing")
    private final TaskRoutingConfiguration taskRouting;

    public WorkflowConfiguration(List<WorkflowRule> workflowRules, WorkflowRuleTarget defaultTarget) throws Exception {
        this.taskRouting = new TaskRoutingConfiguration(workflowRules, defaultTarget);
    }

    @JsonCreator
    public WorkflowConfiguration(@JsonProperty(value="task_routing") TaskRoutingConfiguration taskRouting) {
        this.taskRouting = taskRouting;
    }

    @JsonIgnore
    public List<WorkflowRule> getWorkflowRules() {
        return this.taskRouting.getWorkflowRules();
    }

    @JsonIgnore
    public WorkflowRuleTarget getDefaultTarget() {
        return this.taskRouting.getDefaultTarget();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    public String toJSON() throws JsonGenerationException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        mapper.writeValue((OutputStream)out, (Object)this);
        String workflowJSON = out.toString();
        return workflowJSON;
    }

    public static WorkflowConfiguration parse(String configurationJSON) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (WorkflowConfiguration)mapper.readValue(configurationJSON, WorkflowConfiguration.class);
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    static class TaskRoutingConfiguration {
        @JsonProperty(value="filters")
        private List<WorkflowRule> workflowRules;
        @JsonProperty(value="default_filter")
        private WorkflowRuleTarget defaultTarget;

        @JsonCreator
        public TaskRoutingConfiguration(@JsonProperty(value="filters") List<WorkflowRule> workflowRules, @JsonProperty(value="default_filter") WorkflowRuleTarget defaultTarget) throws Exception {
            if (workflowRules == null || workflowRules.isEmpty()) {
                throw new Exception("Workflow Rules are required when defining a workflow");
            }
            this.workflowRules = workflowRules;
            this.defaultTarget = defaultTarget;
        }

        public List<WorkflowRule> getWorkflowRules() {
            return this.workflowRules;
        }

        public void setWorkflowRules(List<WorkflowRule> workflowRules) {
            this.workflowRules = workflowRules;
        }

        public WorkflowRuleTarget getDefaultTarget() {
            return this.defaultTarget;
        }

        public void setDefaultTarget(WorkflowRuleTarget defaultTarget) {
            this.defaultTarget = defaultTarget;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
        }
    }
}

