/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.list.taskrouter;

import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.TwilioTaskRouterClient;
import com.twilio.sdk.resource.NextGenListResource;
import com.twilio.sdk.resource.factory.Factory;
import com.twilio.sdk.resource.instance.taskrouter.StatisticsQueryBuilder;
import com.twilio.sdk.resource.instance.taskrouter.Worker;
import com.twilio.sdk.resource.instance.taskrouter.WorkersStatistics;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.json.simple.JSONObject;

public class WorkerList
extends NextGenListResource<Worker, TwilioTaskRouterClient>
implements Factory<Worker> {
    private String workspaceSid;

    public WorkerList(TwilioTaskRouterClient client, String workspaceSid) {
        super(client);
        this.workspaceSid = workspaceSid;
    }

    public WorkerList(TwilioTaskRouterClient client, String workspaceSid, Map<String, String> filters) {
        super(client, filters);
        this.workspaceSid = workspaceSid;
    }

    @Override
    public Worker create(Map<String, String> params) throws TwilioRestException {
        TwilioRestResponse response = ((TwilioTaskRouterClient)this.getClient()).safeRequest(this.getResourceLocation(), "POST", params);
        return this.makeNew((TwilioTaskRouterClient)this.getClient(), response.toMap());
    }

    @Override
    public Worker create(List<NameValuePair> params) throws TwilioRestException {
        TwilioRestResponse response = ((TwilioTaskRouterClient)this.getClient()).safeRequest(this.getResourceLocation(), "POST", params);
        return this.makeNew((TwilioTaskRouterClient)this.getClient(), response.toMap());
    }

    public Worker create(String friendlyName, Map<String, String> attributes, String activitySid) throws TwilioRestException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("FriendlyName", friendlyName);
        if (attributes != null) {
            params.put("Attributes", JSONObject.toJSONString(attributes));
        } else {
            params.put("Attributes", "{}");
        }
        if (activitySid != null) {
            params.put("ActivitySid", activitySid);
        }
        TwilioRestResponse response = ((TwilioTaskRouterClient)this.getClient()).safeRequest(this.getResourceLocation(), "POST", params);
        return this.makeNew((TwilioTaskRouterClient)this.getClient(), response.toMap());
    }

    @Override
    protected Worker makeNew(TwilioTaskRouterClient client, Map<String, Object> params) {
        return new Worker(client, params);
    }

    public WorkersStatistics getStatistics() {
        return this.getStatistics(new HashMap<String, String>());
    }

    public WorkersStatistics getStatistics(StatisticsQueryBuilder queryBuilder) {
        HashMap<String, String> filters = new HashMap<String, String>();
        Calendar startDate = queryBuilder.getStartDate();
        Calendar endDate = queryBuilder.getEndDate();
        Integer minutes = queryBuilder.getMinutes();
        if (startDate != null) {
            filters.put("StartDate", this.formatCalendar(startDate));
        }
        if (endDate != null) {
            filters.put("EndDate", this.formatCalendar(endDate));
        }
        if (minutes != null) {
            filters.put("Minutes", minutes.toString());
        }
        return this.getStatistics(filters);
    }

    public WorkersStatistics getStatistics(Map<String, String> filters) {
        String startDate = filters.get("StartDate");
        String endDate = filters.get("EndDate");
        String minutes = filters.get("Minutes");
        if ((startDate != null || endDate != null) && minutes != null) {
            throw new IllegalArgumentException("Cannot provide Minutes in combination with StartDate or EndDate");
        }
        WorkersStatistics statistics = new WorkersStatistics((TwilioTaskRouterClient)this.getClient(), this.workspaceSid, filters);
        return statistics;
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Workspaces/" + this.workspaceSid + "/Workers";
    }
}

