/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.trunking;

import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.TwilioTrunkingClient;
import com.twilio.sdk.resource.NextGenInstanceResource;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class PhoneNumber
extends NextGenInstanceResource<TwilioTrunkingClient> {
    public PhoneNumber(TwilioTrunkingClient client, String trunkSid, String phoneNumberSid) {
        super(client);
        if (StringUtils.isEmpty((CharSequence)trunkSid)) {
            throw new IllegalArgumentException("trunkSid cannot be null");
        }
        if (StringUtils.isEmpty((CharSequence)phoneNumberSid)) {
            throw new IllegalArgumentException("phoneNumberSid cannot be null");
        }
        this.setProperty("trunk_sid", trunkSid);
        this.setProperty("sid", phoneNumberSid);
    }

    public PhoneNumber(TwilioTrunkingClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    public String getApiVersion() {
        return this.getProperty("api_version");
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getTrunkSid() {
        return this.getProperty("trunk_sid");
    }

    public String getFriendlyName() {
        return this.getProperty("friendly_name");
    }

    public String getSipUrl() {
        return this.getProperty("sip_url");
    }

    public Calendar getDateCreated() {
        return this.parseCalendar(this.getProperty("date_created"));
    }

    public Calendar getDateUpdated() {
        return this.parseCalendar(this.getProperty("date_updated"));
    }

    public String getUrl() {
        return this.getProperty("url");
    }

    public String getPhoneNumber() {
        return this.getProperty("phone_number");
    }

    public Boolean isVoiceCallerIdLookup() {
        return (Boolean)this.getObject("voice_caller_id_lookup");
    }

    public String getVoiceUrl() {
        return this.getProperty("voice_url");
    }

    public String getVoiceMethod() {
        return this.getProperty("voice_method");
    }

    public String getVoiceFallbackUrl() {
        return this.getProperty("voice_fallback_url");
    }

    public String getVoiceFallbackMethod() {
        return this.getProperty("voice_fallback_method");
    }

    public String getStatusCallback() {
        return this.getProperty("status_callback");
    }

    public String getStatusCallbackMethod() {
        return this.getProperty("status_callback_method");
    }

    public String getVoiceApplicationSid() {
        return this.getProperty("voice_application_sid");
    }

    public String getSmsUrl() {
        return this.getProperty("sms_url");
    }

    public String getSmsMethod() {
        return this.getProperty("sms_method");
    }

    public String getSmsFallbackUrl() {
        return this.getProperty("sms_fallback_url");
    }

    public String getSmsFallbackMethod() {
        return this.getProperty("sms_fallback_method");
    }

    public String getSmsStatusCallback() {
        return this.getProperty("sms_status_callback");
    }

    public String getAddressRequirements() {
        return this.getProperty("address_requirements");
    }

    public Boolean isBeta() {
        return (Boolean)this.getObject("beta");
    }

    public Capabilities getCapabilities() {
        return new Capabilities((Map)this.getObject("capabilities"));
    }

    public boolean delete() throws TwilioRestException {
        TwilioRestResponse response = ((TwilioTrunkingClient)this.getClient()).safeRequest(this.getResourceLocation(), "DELETE", (Map<String, String>)null);
        return !response.isError();
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Trunks/" + this.getTrunkSid() + "/PhoneNumbers" + this.getSid();
    }

    public class Capabilities {
        private final Map<String, Object> data;

        public Capabilities(Map<String, Object> data) {
            this.data = data;
        }

        public Boolean isVoice() {
            return (Boolean)this.data.get("voice");
        }

        public Boolean isSms() {
            return (Boolean)this.data.get("sms");
        }

        public Boolean isMms() {
            return (Boolean)this.data.get("mms");
        }
    }
}

