/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.taskrouter;

import com.twilio.sdk.TwilioTaskRouterClient;
import com.twilio.sdk.resource.NextGenInstanceResource;
import com.twilio.sdk.resource.instance.taskrouter.ActivityDuration;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class WorkerStatistics
extends NextGenInstanceResource<TwilioTaskRouterClient> {
    private static final String CUMULATIVE_PROPERTY = "cumulative";
    private static final String WORKER_SID_PROPERTY = "worker_sid";
    private static final String WORKSPACE_SID_PROPERTY = "workspace_sid";

    public WorkerStatistics(TwilioTaskRouterClient client, String workspaceSid, String workerSid) {
        this(client, workspaceSid, workerSid, null);
    }

    public WorkerStatistics(TwilioTaskRouterClient client, String workspaceSid, String workerSid, Map<String, String> filters) {
        super(client);
        if (StringUtils.isBlank((CharSequence)workspaceSid)) {
            throw new IllegalArgumentException("The workspaceSid for a WorkerStatistics cannot be null");
        }
        if (StringUtils.isBlank((CharSequence)workerSid)) {
            throw new IllegalArgumentException("The workerSid for a WorkerStatistics cannot be null");
        }
        this.setProperty(WORKSPACE_SID_PROPERTY, workspaceSid);
        this.setProperty(WORKER_SID_PROPERTY, workerSid);
        this.filters = filters;
    }

    public Set<ActivityDuration> getActivityDurations() {
        try {
            List props = (List)this.getCumulative().get("activity_durations");
            HashSet<ActivityDuration> activityDurations = new HashSet<ActivityDuration>();
            for (Map prop : props) {
                ActivityDuration activityDuration = this.mapToActivityDuration(prop);
                activityDurations.add(activityDuration);
            }
            return Collections.unmodifiableSet(activityDurations);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Calendar getEndTime() {
        return this.parseCalendar((String)this.getCumulative().get("end_time"));
    }

    public Integer getReservationsAccepted() {
        return (Integer)this.getCumulative().get("reservations_accepted");
    }

    public Integer getReservationsRejected() {
        return (Integer)this.getCumulative().get("reservations_rejected");
    }

    public Integer getReservationsTimedOut() {
        return (Integer)this.getCumulative().get("reservations_timed_out");
    }

    public Calendar getStartTime() {
        return this.parseCalendar((String)this.getCumulative().get("start_time"));
    }

    public Integer getTasksAssigned() {
        return (Integer)this.getCumulative().get("tasks_assigned");
    }

    public String getWorkerSid() {
        return this.getProperty(WORKER_SID_PROPERTY);
    }

    public String getWorkspaceSid() {
        return this.getProperty(WORKSPACE_SID_PROPERTY);
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Workspaces/" + this.getWorkspaceSid() + "/Workers/" + this.getWorkerSid() + "/Statistics";
    }

    private Map<String, Object> getCumulative() {
        return (Map)this.getObject(CUMULATIVE_PROPERTY);
    }

    private ActivityDuration mapToActivityDuration(Map<String, Object> data) {
        Double average;
        Integer minimum;
        Integer maximum;
        String friendlyName;
        String sid;
        block5: {
            try {
                sid = (String)data.get("sid");
                friendlyName = (String)data.get("friendly_name");
                maximum = (Integer)data.get("maximum");
                minimum = (Integer)data.get("minimum");
                try {
                    Object prop = this.getObject("average");
                    if (prop instanceof Integer) {
                        average = Double.parseDouble(prop.toString());
                        break block5;
                    }
                    average = (Double)prop;
                }
                catch (IllegalArgumentException e) {
                    average = null;
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("An Activity Duration contained improperly formatted data.", e);
            }
        }
        return new ActivityDuration(sid, friendlyName, average, maximum, minimum);
    }
}

