/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.sip;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.InstanceResource;
import com.twilio.sdk.resource.factory.sip.CredentialFactory;
import com.twilio.sdk.resource.instance.sip.Credential;
import com.twilio.sdk.resource.list.sip.CredentialList;
import java.util.Date;
import java.util.Map;

public class CredentialListInstance
extends InstanceResource<TwilioRestClient> {
    public CredentialListInstance(TwilioRestClient client) {
        super(client);
    }

    public CredentialListInstance(TwilioRestClient client, String sid) {
        super(client);
        if (sid == null) {
            throw new IllegalStateException("The Sid for a CredentialListInstance can not be null");
        }
        this.setProperty("sid", sid);
    }

    public CredentialListInstance(TwilioRestClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    @Override
    protected String getResourceLocation() {
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/SIP/CredentialLists/" + this.getSid() + ".json";
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public Date getDateCreated() {
        return this.getDateProperty("date_created");
    }

    public Date getDateUpdated() {
        return this.getDateProperty("date_updated");
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getRealm() {
        return this.getProperty("realm");
    }

    public String getFriendlyName() {
        return this.getProperty("friendly_name");
    }

    public CredentialList getCredentials() {
        CredentialList credentials = new CredentialList((TwilioRestClient)this.getClient(), this.getSid());
        credentials.setRequestAccountSid(this.getRequestAccountSid());
        return credentials;
    }

    public Credential getCredential(String credentialSid) {
        Credential credential = new Credential((TwilioRestClient)this.getClient(), this.getSid(), credentialSid);
        credential.setRequestAccountSid(this.getRequestAccountSid());
        return credential;
    }

    public CredentialFactory getCredentialFactory() {
        return this.getCredentials();
    }

    public boolean delete() throws TwilioRestException {
        TwilioRestResponse response = ((TwilioRestClient)this.getClient()).safeRequest(this.getResourceLocation(), "DELETE", (Map<String, String>)null);
        return !response.isError();
    }
}

