/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.pricing;

import com.twilio.sdk.TwilioPricingClient;
import com.twilio.sdk.resource.NextGenInstanceResource;
import com.twilio.sdk.resource.instance.pricing.NumberType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class PhoneNumberCountry
extends NextGenInstanceResource<TwilioPricingClient> {
    public PhoneNumberCountry(TwilioPricingClient client) {
        super(client);
    }

    public PhoneNumberCountry(TwilioPricingClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    public PhoneNumberCountry(TwilioPricingClient client, String isoCountry) {
        super(client);
        if (isoCountry == null || "".equals(isoCountry)) {
            throw new IllegalArgumentException("isoCountry cannot be null");
        }
        this.setProperty("iso_country", isoCountry);
    }

    public String getIsoCountry() {
        return this.getProperty("iso_country");
    }

    public String getCountry() {
        return this.getProperty("country");
    }

    public String getPriceUnit() {
        return this.getProperty("price_unit");
    }

    public List<NumberPrice> getPhoneNumberPrices() {
        List priceData = (List)this.getCastedObject("phone_number_prices");
        ArrayList<NumberPrice> prices = new ArrayList<NumberPrice>();
        for (Map p : priceData) {
            prices.add(new NumberPrice(NumberType.valueOf(((String)p.get("number_type")).replace(' ', '_').toUpperCase()), new BigDecimal((String)p.get("base_price")), new BigDecimal((String)p.get("current_price"))));
        }
        return prices;
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/PhoneNumbers/Countries/" + this.getIsoCountry();
    }

    public class NumberPrice {
        private final NumberType numberType;
        private final BigDecimal basePrice;
        private final BigDecimal currentPrice;

        public NumberPrice(NumberType numberType, BigDecimal basePrice, BigDecimal currentPrice) {
            this.numberType = numberType;
            this.basePrice = basePrice;
            this.currentPrice = currentPrice;
        }

        public NumberType getNumberType() {
            return this.numberType;
        }

        public BigDecimal getBasePrice() {
            return this.basePrice;
        }

        public BigDecimal getCurrentPrice() {
            return this.currentPrice;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NumberPrice that = (NumberPrice)o;
            return new EqualsBuilder().append((Object)this.basePrice, (Object)that.basePrice).append((Object)this.currentPrice, (Object)that.currentPrice).append((Object)this.numberType, (Object)that.numberType).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.numberType).append((Object)this.basePrice).append((Object)this.currentPrice).toHashCode();
        }
    }
}

