/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.monitor;

import com.twilio.sdk.TwilioMonitorClient;
import com.twilio.sdk.resource.NextGenInstanceResource;
import java.util.Calendar;
import java.util.Map;

public class Event
extends NextGenInstanceResource<TwilioMonitorClient> {
    public Event(TwilioMonitorClient client) {
        super(client);
    }

    public Event(TwilioMonitorClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    public Event(TwilioMonitorClient client, String eventSid) {
        super(client);
        if (eventSid == null || "".equals(eventSid)) {
            throw new IllegalArgumentException("The eventSid for an Event cannot be null");
        }
        this.setProperty("sid", eventSid);
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getActorSid() {
        return this.getProperty("actor_sid");
    }

    public String getActorType() {
        return this.getProperty("actor_type");
    }

    public String getActorUrl() {
        Map links = (Map)this.getObject("links");
        return (String)links.get("actor");
    }

    public String getDescription() {
        return this.getProperty("description");
    }

    public Map<String, Map<String, Object>> getEventData() {
        return (Map)this.getObject("event_data");
    }

    public Calendar getEventDate() {
        return this.parseCalendar(this.getProperty("event_date"));
    }

    public String getEventType() {
        return this.getProperty("event_type");
    }

    public String getResourceSid() {
        return this.getProperty("resource_sid");
    }

    public String getResourceType() {
        return this.getProperty("resource_type");
    }

    public String getResourceUrl() {
        Map links = (Map)this.getObject("links");
        return (String)links.get("resource");
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public String getSource() {
        return this.getProperty("source");
    }

    public String getSourceIpAddress() {
        return this.getProperty("source_ip_address");
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Events/" + this.getSid();
    }
}

