/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource;

import com.twilio.sdk.TwilioClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.NextGenInstanceResource;
import com.twilio.sdk.resource.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class NextGenListResource<T extends NextGenInstanceResource, C extends TwilioClient>
extends Resource<C>
implements Iterable<T> {
    protected List<T> pageData;
    private String nextPageUrl = null;
    private int page = 0;
    private int pageSize = 0;
    private String previousPageUrl = null;
    private String url = null;

    public NextGenListResource(C client) {
        this(client, new HashMap<String, String>());
    }

    public NextGenListResource(C client, Map<String, String> filters) {
        super(client);
        this.filters = filters;
    }

    @Override
    public Iterator<T> iterator() {
        return new ListIterator(this.getPageData().iterator());
    }

    public List<T> getPageData() {
        if (!this.isLoaded()) {
            try {
                this.load(this.filters);
            }
            catch (TwilioRestException e) {
                throw new RuntimeException(e);
            }
        }
        return Collections.unmodifiableList(this.pageData);
    }

    public String getNextPageUrl() {
        return this.nextPageUrl;
    }

    public int getPage() {
        return this.page;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public String getPreviousPageUrl() {
        return this.previousPageUrl;
    }

    public String getUrl() {
        return this.url;
    }

    protected boolean hasNextPage() {
        return this.nextPageUrl != null && this.nextPageUrl.length() > 0;
    }

    protected void fetchNextPage() throws TwilioRestException {
        TwilioRestResponse response = ((TwilioClient)this.getClient()).get(this.nextPageUrl);
        this.parseResponse(response);
    }

    @Override
    protected void parseResponse(TwilioRestResponse response) {
        Map<String, Object> data = response.toMap();
        Map meta = (Map)data.get("meta");
        if (meta == null) {
            throw new RuntimeException("Paging metadata not found in Twilio response");
        }
        this.nextPageUrl = (String)meta.get("next_page_url");
        this.previousPageUrl = (String)meta.get("previous_page_url");
        this.page = this.getIntValue(meta.get("page"));
        this.pageSize = this.getIntValue(meta.get("page_size"));
        this.url = (String)meta.get("url");
        this.pageData = this.toList(response);
    }

    protected List<T> toList(TwilioRestResponse response) {
        Map meta;
        String resourceKey;
        ArrayList returnList = new ArrayList();
        Map<String, Object> data = response.toMap();
        Object content = data.get(resourceKey = (String)(meta = (Map)data.get("meta")).get("key"));
        if (content instanceof List) {
            List objs = (List)content;
            for (Object o : objs) {
                this.extract_object(returnList, o);
            }
        } else if (content instanceof Map) {
            this.extract_object(returnList, content);
        }
        return returnList;
    }

    protected abstract T makeNew(C var1, Map<String, Object> var2);

    private void extract_object(List<T> returnList, Object o) {
        if (o instanceof Map) {
            T instance = this.makeNew(this.getClient(), (Map)o);
            returnList.add(instance);
        }
    }

    private int getIntValue(Object data) {
        if (data instanceof Integer) {
            return (Integer)data;
        }
        if (data instanceof String) {
            return Integer.parseInt((String)data);
        }
        return -1;
    }

    private class ListIterator
    implements Iterator<T> {
        private Iterator<T> iterator;

        public ListIterator(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            NextGenInstanceResource nextElement = (NextGenInstanceResource)this.iterator.next();
            if (!this.iterator.hasNext() && NextGenListResource.this.hasNextPage()) {
                try {
                    NextGenListResource.this.fetchNextPage();
                }
                catch (TwilioRestException e) {
                    throw new RuntimeException(e);
                }
                this.iterator = NextGenListResource.this.pageData.iterator();
            }
            return nextElement;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

