/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource;

import com.twilio.sdk.TwilioClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.parser.ResponseParser;
import com.twilio.sdk.resource.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class ListResource<T extends Resource, C extends TwilioClient>
extends Resource<C>
implements Iterable<T> {
    protected List<T> pageData;
    private String nextUri = null;
    private int start = 0;
    private int end = 0;
    private int page = 0;

    @Override
    public Iterator<T> iterator() {
        return new ListIterator(this.getPageData().iterator());
    }

    public ListResource(C client) {
        this(client, new HashMap<String, String>());
    }

    public ListResource(C client, Map<String, String> filters) {
        super(client);
        this.filters = filters;
    }

    public String getNextUri() {
        return this.nextUri;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getPage() {
        return this.page;
    }

    protected boolean hasNextPage() {
        return this.nextUri != null && this.nextUri.length() > 0;
    }

    protected void fetchNextPage() throws TwilioRestException {
        TwilioRestResponse response = ((TwilioClient)this.getClient()).get(this.nextUri);
        this.parseResponse(response);
    }

    public List<T> getPageData() {
        if (!this.isLoaded()) {
            try {
                this.load(this.filters);
            }
            catch (TwilioRestException e) {
                throw new RuntimeException(e);
            }
        }
        return Collections.unmodifiableList(this.pageData);
    }

    @Override
    protected void parseResponse(TwilioRestResponse response) {
        this.nextUri = null;
        Map<String, Object> data = response.toMap();
        this.nextUri = (String)data.get(response.getParser().getPagingPropertyKey(ResponseParser.PagingProperty.NEXT_PAGE_URI_KEY));
        this.start = this.getIntValue(data.get(response.getParser().getPagingPropertyKey(ResponseParser.PagingProperty.START_KEY)));
        this.end = this.getIntValue(data.get(response.getParser().getPagingPropertyKey(ResponseParser.PagingProperty.END_KEY)));
        this.page = this.getIntValue(data.get(response.getParser().getPagingPropertyKey(ResponseParser.PagingProperty.PAGE_KEY)));
        this.pageData = this.toList(response);
    }

    private int getIntValue(Object data) {
        if (data instanceof Integer) {
            return (Integer)data;
        }
        if (data instanceof String) {
            return Integer.parseInt((String)data);
        }
        return -1;
    }

    protected abstract T makeNew(C var1, Map<String, Object> var2);

    protected abstract String getListKey();

    protected List<T> toList(TwilioRestResponse response) {
        ArrayList returnList = new ArrayList();
        Map<String, Object> list = response.toMap();
        Object content = list.get(this.getListKey());
        if (content instanceof List) {
            List objs = (List)list.get(this.getListKey());
            for (Object o : objs) {
                this.extract_object(returnList, o);
            }
        } else if (content instanceof Map) {
            this.extract_object(returnList, ((Map)content).values().iterator().next());
        }
        return returnList;
    }

    private void extract_object(List<T> returnList, Object o) {
        if (o instanceof Map) {
            T instance = this.makeNew(this.getClient(), (Map)o);
            if (((Resource)instance).getRequestAccountSid() == null) {
                ((Resource)instance).setRequestAccountSid(this.getRequestAccountSid());
            }
            returnList.add(instance);
        }
    }

    private class ListIterator
    implements Iterator<T> {
        private Iterator<T> iterator;

        public ListIterator(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            Resource nextElement = (Resource)this.iterator.next();
            if (!this.iterator.hasNext() && ListResource.this.hasNextPage()) {
                try {
                    ListResource.this.fetchNextPage();
                }
                catch (TwilioRestException e) {
                    throw new RuntimeException(e);
                }
                this.iterator = ListResource.this.pageData.iterator();
            }
            return nextElement;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

