/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.examples;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.factory.CallFactory;
import com.twilio.sdk.resource.factory.MessageFactory;
import com.twilio.sdk.resource.instance.Account;
import com.twilio.sdk.resource.instance.AvailablePhoneNumber;
import com.twilio.sdk.resource.instance.Call;
import com.twilio.sdk.resource.instance.Conference;
import com.twilio.sdk.resource.instance.Participant;
import com.twilio.sdk.resource.list.AccountList;
import com.twilio.sdk.resource.list.AvailablePhoneNumberList;
import com.twilio.sdk.resource.list.ParticipantList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class RestExamples {
    public static final String ACCOUNT_SID = "AC123";
    public static final String AUTH_TOKEN = "456bef";

    public static void main(String[] args) throws TwilioRestException {
        TwilioRestClient client = new TwilioRestClient(ACCOUNT_SID, AUTH_TOKEN);
        Account mainAccount = client.getAccount();
        AccountList accountList = client.getAccounts();
        for (Account a : accountList) {
            System.out.println(a.getFriendlyName());
        }
        for (Account a : accountList) {
            System.out.println(a.getFriendlyName());
        }
        accountList = client.getAccounts();
        List accounts = accountList.getPageData();
        CallFactory callFactory = mainAccount.getCallFactory();
        HashMap<String, String> callParams = new HashMap<String, String>();
        callParams.put("To", "5105551212");
        callParams.put("From", "(510) 555-1212");
        callParams.put("Url", "http://demo.twilio.com/welcome/voice/");
        Call call = callFactory.create(callParams);
        System.out.println(call.getSid());
        MessageFactory messageFactory = mainAccount.getMessageFactory();
        ArrayList<NameValuePair> messageParams = new ArrayList<NameValuePair>();
        messageParams.add((NameValuePair)new BasicNameValuePair("To", "5105551212"));
        messageParams.add((NameValuePair)new BasicNameValuePair("From", "(510) 555-1212"));
        messageParams.add((NameValuePair)new BasicNameValuePair("Body", "This is a test message!"));
        messageFactory.create(messageParams);
        AvailablePhoneNumberList phoneNumbers = mainAccount.getAvailablePhoneNumbers();
        List phoneNumberList = phoneNumbers.getPageData();
        HashMap<String, String> areaCodeFilter = new HashMap<String, String>();
        areaCodeFilter.put("AreaCode", "94103");
        AvailablePhoneNumberList phoneNumbersByAreaCode = mainAccount.getAvailablePhoneNumbers(areaCodeFilter);
        List phoneNumbersByAreaCodeList = phoneNumbersByAreaCode.getPageData();
        HashMap<String, String> smsFilter = new HashMap<String, String>();
        smsFilter.put("SmsEnabled", "true");
        AvailablePhoneNumberList phoneNumbersByCountryAndSms = mainAccount.getAvailablePhoneNumbers(smsFilter, "GB", "Local");
        List phoneNumbersByCountryAndSmsList = phoneNumbersByCountryAndSms.getPageData();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("PhoneNumber", ((AvailablePhoneNumber)phoneNumberList.get(0)).getPhoneNumber());
        params.put("VoiceUrl", "http://demo.twilio.com/welcome/voice/");
        Conference c = mainAccount.getConference("CA12345...");
        ParticipantList participants = c.getParticipants();
        for (Participant p : participants) {
            if (Math.random() > 0.5) {
                p.mute();
                continue;
            }
            p.kick();
        }
        TwilioRestResponse resp = client.request("/2010-04-01/Accounts", "GET", (Map<String, String>)null);
        if (!resp.isError()) {
            System.out.println(resp.getResponseText());
        }
    }
}

