/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.examples;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.resource.list.MessageList;

public class AuthExamples {
    public static final String ACCOUNT_SID = "account_sid";
    public static final String AUTH_TOKEN = "auth_token";
    public static final String SIGNINGKEY_SID = "key";
    public static final String SIGNINGKEY_SECRET = "secret";

    public static void main(String[] args) throws Exception {
        AuthExamples.authUsingAuthToken();
        AuthExamples.authUsingKeys();
    }

    public static void authUsingAuthToken() throws Exception {
        TwilioRestClient client = new TwilioRestClient(ACCOUNT_SID, AUTH_TOKEN);
        MessageList messages = client.getAccount().getMessages();
        System.out.println("Got back " + messages.getPageData().size() + " messages using auth token");
    }

    public static void authUsingKeys() throws Exception {
        TwilioRestClient client = new TwilioRestClient(SIGNINGKEY_SID, SIGNINGKEY_SECRET);
        client.setRequestAccountSid(ACCOUNT_SID);
        MessageList messages = client.getAccount().getMessages();
        System.out.println("Got back " + messages.getPageData().size() + " messages using signing keys");
    }
}

