/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.list.taskrouter;

import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.TwilioTaskRouterClient;
import com.twilio.sdk.resource.NextGenListResource;
import com.twilio.sdk.resource.factory.taskrouter.TaskQueueFactory;
import com.twilio.sdk.resource.instance.taskrouter.TaskQueue;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;

public class TaskQueueList
extends NextGenListResource<TaskQueue, TwilioTaskRouterClient>
implements TaskQueueFactory {
    private String workspaceSid;

    public TaskQueueList(TwilioTaskRouterClient client, String workspaceSid) {
        super(client);
        this.workspaceSid = workspaceSid;
    }

    public TaskQueueList(TwilioTaskRouterClient client, String workspaceSid, Map<String, String> filters) {
        super(client, filters);
        this.workspaceSid = workspaceSid;
    }

    @Override
    public TaskQueue create(Map<String, String> params) throws TwilioRestException {
        TwilioRestResponse response = ((TwilioTaskRouterClient)this.getClient()).safeRequest(this.getResourceLocation(), "POST", params);
        return this.makeNew((TwilioTaskRouterClient)this.getClient(), response.toMap());
    }

    @Override
    public TaskQueue create(List<NameValuePair> params) throws TwilioRestException {
        TwilioRestResponse response = ((TwilioTaskRouterClient)this.getClient()).safeRequest(this.getResourceLocation(), "POST", params);
        return this.makeNew((TwilioTaskRouterClient)this.getClient(), response.toMap());
    }

    @Override
    protected TaskQueue makeNew(TwilioTaskRouterClient client, Map<String, Object> params) {
        return new TaskQueue(client, params);
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Workspaces/" + this.workspaceSid + "/TaskQueues";
    }
}

