/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.taskrouter;

import com.twilio.sdk.TwilioTaskRouterClient;
import com.twilio.sdk.resource.NextGenInstanceResource;
import java.util.Date;
import java.util.Map;

public class Worker
extends NextGenInstanceResource<TwilioTaskRouterClient> {
    private static final String WORKSPACE_SID_PROPERTY = "workspace_sid";

    public Worker(TwilioTaskRouterClient client) {
        super(client);
    }

    public Worker(TwilioTaskRouterClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    public Worker(TwilioTaskRouterClient client, String workspaceSid, String workerSid) {
        super(client);
        if (workspaceSid == null || "".equals(workspaceSid)) {
            throw new IllegalArgumentException("The workspaceSid for an Worker cannot be null");
        }
        if (workerSid == null || "".equals(workerSid)) {
            throw new IllegalArgumentException("The workerSid for an Worker cannot be null");
        }
        this.setProperty(WORKSPACE_SID_PROPERTY, workspaceSid);
        this.setProperty("sid", workerSid);
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getActivityName() {
        return this.getProperty("activity_name");
    }

    public String getActivitySid() {
        return this.getProperty("activity_sid");
    }

    public String getAttributes() {
        return this.getProperty("attributes");
    }

    public Date getDateCreated() {
        return this.parseDate(this.getProperty("date_created"));
    }

    public Date getDateStatusChanged() {
        return this.parseDate(this.getProperty("date_status_changed"));
    }

    public Date getDateUpdated() {
        return this.parseDate(this.getProperty("date_updated"));
    }

    public String getFriendlyName() {
        return this.getProperty("friendly_name");
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public String getWorkspaceSid() {
        return this.getProperty(WORKSPACE_SID_PROPERTY);
    }

    public boolean isAvailable() {
        return (Boolean)this.getObject("available");
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Workspaces/" + this.getWorkspaceSid() + "/Workers/" + this.getSid();
    }
}

