/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.taskrouter;

import com.twilio.sdk.TwilioTaskRouterClient;
import com.twilio.sdk.resource.NextGenInstanceResource;
import java.util.Date;
import java.util.Map;

public class TaskQueue
extends NextGenInstanceResource<TwilioTaskRouterClient> {
    private static final String WORKSPACE_SID_PROPERTY = "workspace_sid";

    public TaskQueue(TwilioTaskRouterClient client) {
        super(client);
    }

    public TaskQueue(TwilioTaskRouterClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    public TaskQueue(TwilioTaskRouterClient client, String workspaceSid, String queueSid) {
        super(client);
        if (workspaceSid == null || "".equals(workspaceSid)) {
            throw new IllegalArgumentException("The workspaceSid for a TaskQueue cannot be null");
        }
        if (queueSid == null || "".equals(queueSid)) {
            throw new IllegalArgumentException("The queueSid for a TaskQueue cannot be null");
        }
        this.setProperty(WORKSPACE_SID_PROPERTY, workspaceSid);
        this.setProperty("sid", queueSid);
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getAssignmentActivitySid() {
        return this.getProperty("assignment_activity_sid");
    }

    public Date getDateCreated() {
        return this.parseDate(this.getProperty("date_created"));
    }

    public Date getDateUpdated() {
        return this.parseDate(this.getProperty("date_updated"));
    }

    public String getFriendlyName() {
        return this.getProperty("friendly_name");
    }

    public String getReservationActivityName() {
        return this.getProperty("reservation_activity_name");
    }

    public String getReservationActivitySid() {
        return this.getProperty("reservation_activity_sid");
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public String getTargetWorkers() {
        return this.getProperty("target_workers");
    }

    public String getWorkspaceSid() {
        return this.getProperty(WORKSPACE_SID_PROPERTY);
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Workspaces/" + this.getWorkspaceSid() + "/TaskQueues/" + this.getSid();
    }
}

