/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.monitor;

import com.twilio.sdk.TwilioMonitorClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.NextGenInstanceResource;
import java.util.Calendar;
import java.util.Map;

public class Alert
extends NextGenInstanceResource<TwilioMonitorClient> {
    public Alert(TwilioMonitorClient client) {
        super(client);
    }

    public Alert(TwilioMonitorClient client, String sid) {
        super(client);
        if (sid == null) {
            throw new IllegalStateException("The Sid for a Notification can not be null");
        }
        this.setProperty("sid", sid);
    }

    public Alert(TwilioMonitorClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Alerts/" + this.getSid();
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public String getUrl() {
        return this.getProperty("url");
    }

    public Calendar getDateCreated() {
        return this.parseCalendar(this.getProperty("date_created"));
    }

    public Calendar getDateGenerated() {
        return this.parseCalendar(this.getProperty("date_generated"));
    }

    public Calendar getDateUpdated() {
        return this.parseCalendar(this.getProperty("date_updated"));
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getResourceSid() {
        return this.getProperty("resource_sid");
    }

    public String getApiVersion() {
        return this.getProperty("api_version");
    }

    public String getLogLevel() {
        return this.getProperty("log_level");
    }

    public String getErrorCode() {
        return this.getProperty("error_code");
    }

    public String getMoreInfo() {
        return this.getProperty("more_info");
    }

    public String getAlertText() {
        return this.getProperty("alert_text");
    }

    public String getRequestUrl() {
        return this.getProperty("request_url");
    }

    public String getRequestMethod() {
        return this.getProperty("request_method");
    }

    public String getRequestVariables() {
        return this.getProperty("request_variables");
    }

    public String getResponseHeaders() {
        return this.getProperty("response_headers");
    }

    public String getResponseBody() {
        return this.getProperty("response_body");
    }

    public boolean delete() throws TwilioRestException {
        TwilioRestResponse response = ((TwilioMonitorClient)this.getClient()).safeRequest(this.getResourceLocation(), "DELETE", (Map<String, String>)null);
        return !response.isError();
    }
}

