/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk;

import com.twilio.sdk.AppEngineClientConnection;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.params.HttpParams;

public class AppEngineClientConnectionManager
implements ClientConnectionManager {
    private final SchemeRegistry schemes;

    public AppEngineClientConnectionManager() {
        NoOpSocketFactory noOpSocketFactory = new NoOpSocketFactory();
        this.schemes = new SchemeRegistry();
        this.schemes.register(new Scheme("http", 80, (SchemeSocketFactory)noOpSocketFactory));
        this.schemes.register(new Scheme("https", 443, (SchemeSocketFactory)noOpSocketFactory));
    }

    public void closeExpiredConnections() {
    }

    public void closeIdleConnections(long idleTime, TimeUnit timeUnit) {
    }

    public ManagedClientConnection getConnection(HttpRoute route, Object state) {
        return new AppEngineClientConnection(this, route, state);
    }

    public SchemeRegistry getSchemeRegistry() {
        return this.schemes;
    }

    public void releaseConnection(ManagedClientConnection conn, long valid, TimeUnit timeUnit) {
    }

    public ClientConnectionRequest requestConnection(final HttpRoute route, final Object state) {
        return new ClientConnectionRequest(){

            public void abortRequest() {
            }

            public ManagedClientConnection getConnection(long idleTime, TimeUnit timeUnit) {
                return AppEngineClientConnectionManager.this.getConnection(route, state);
            }
        };
    }

    public void shutdown() {
    }

    class NoOpSocketFactory
    implements SchemeSocketFactory {
        NoOpSocketFactory() {
        }

        public Socket connectSocket(Socket sock, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
            return null;
        }

        public Socket createSocket(HttpParams params) throws IOException {
            return null;
        }

        public boolean isSecure(Socket sock) {
            return false;
        }
    }
}

