package com.twilio.sdk.resource.instance.monitor;

import com.twilio.sdk.TwilioMonitorClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.NextGenInstanceResource;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;

// TODO: Auto-generated Javadoc

/**
 * The Class Notification.
 *
 * For more information see <a href="https://www.twilio.com/docs/api/rest/notification">https://www.twilio.com/docs/api/rest/monitor-alerts</a>
 */
public class Alert extends NextGenInstanceResource<TwilioMonitorClient> {

	/**
	 * Instantiates a new Alert resource.
	 *
	 * @param client the client
	 */
	public Alert(TwilioMonitorClient client) {
		super(client);
	}

	/**
	 * Instantiates a new Alert resource.
	 *
	 * @param client the client
	 * @param sid the sid
	 */
	public Alert(TwilioMonitorClient client, String sid) {
		super(client);
		if (sid == null) {
			throw new IllegalStateException("The Sid for a Notification can not be null");
		}
		this.setProperty(SID_PROPERTY, sid);
	}

	/**
	 * Instantiates a new Alert resource with properties returned from the Twilio API.
	 *
	 * @param client the client
	 * @param properties the properties
	 */
	public Alert(TwilioMonitorClient client, Map<String, Object> properties) {
		super(client, properties);
	}

	/* (non-Javadoc)
	 * @see com.twilio.sdk.resource.Resource#getResourceLocation()
	 */
	@Override
	protected String getResourceLocation() {
		return "/" + TwilioMonitorClient.DEFAULT_VERSION + "/Alerts/" + getSid();
	}

	/*
	 * Property getters
	 */

	/**
	 * Unique ID for this Alert.
	 *
	 * @return Alert sid.
	 */
	public String getSid() {
		return getProperty(SID_PROPERTY);
	}

	/**
	 * URL of this Alert in the Twilio REST API.
	 *
	 * @return resource URL
	 */
	public String getUrl() {
		return getProperty("url");
	}

	/**
	 * The date that this resource was created.
	 *
	 * @return Calendar representing resource creation time
	 */
	public Calendar getDateCreated() {
		return parseCalendar(getProperty("date_created"));
	}

	/**
	 * The date the alert was actually generated.
	 * Due to buffering, this may be slightly different than the DateCreated date.
	 *
	 * @return Calendar representing the time this Alert was generated
	 */
	public Calendar getDateGenerated() {
		return parseCalendar(getProperty("date_generated"));
	}

	/**
	 * The date this alert was last updated.
	 *
	 * @return Calendar representing last update time
	 */
	public Calendar getDateUpdated() {
		return parseCalendar(getProperty("date_updated"));
	}

	/**
	 * Gets the account sid.
	 *
	 * @return the account sid
	 */
	public String getAccountSid() {
		return getProperty("account_sid");
	}

	/**
	 * The unique ID of the resource for which the Alert was generated.
	 * For instance, if your server failed to respond to an HTTP request
	 * during the flow of a particular call, this will be the ID for the
	 * call that failed.
	 *
	 * Null if the Alert was generated without respect to a particular resource.
	 *
	 * @return ID of the resource related to this Alert, or null
	 */
	public String getResourceSid() {
		return getProperty("resource_sid");
	}

	/**
	 * The version of the Twilio API in use when this alert was generated.
	 * May be null for events that don't have a specific API version.
	 *
	 * @return Twilio API version string, or null
	 */
	public String getApiVersion() {
		return getProperty("api_version");
	}

	/**
	 * The type of alert. One of "error", "warning", "notice", or "debug".
	 *
	 * @return Log level string
	 */
	public String getLogLevel() {
		return getProperty("log_level");
	}

	/**
	 * A unique error code for the error condition.
	 * See <a href="https://twilio.com/docs/errors">twilio.com/docs/errors</a> for a reference.
	 *
	 * @return Twilio error identifier
	 */
	public String getErrorCode() {
		return getProperty("error_code");
	}

	/**
	 * A URL for more information about the error condition.
	 *
	 * @return Error info URL
	 */
	public String getMoreInfo() {
		return getProperty("more_info");
	}

	/**
	 * The text of the alert.
	 *
	 * @return Alert description
	 */
	public String getAlertText() {
		return getProperty("alert_text");
	}

	/**
	 * If the Alert was generated by a request Twilio made to your server,
	 * this will be the URL on your server that generated the alert.
	 *
	 * If the Alert was generated by a request from your application to Twilio's API,
	 * this will be the URL of the resource in Twilio's API.
	 *
	 * @return URL of the failed request, or null
	 */
	public String getRequestUrl() {
		return getProperty("request_url");
	}

	/**
	 * If the Alert was generated by a request Twilio made to your server,
	 * this will be the request method used when Twilio made the request to your server.
	 *
	 * If the Alert was generated by a request from your application to Twilio's API,
	 * this will be the request method your application used in the request to the API.
	 * @return HTTP request method
	 */
	public String getRequestMethod() {
		return getProperty("request_method");
	}

	/**
	 * Only available in the Alert instance resource.
	 * If the Alert was generated by a request Twilio made to your server,
	 * this will be the Twilio-generated HTTP GET or POST variables sent
	 * to your server.
	 *
	 * If the Alert was generated by a request from your application to Twilio's
	 * API, this will be the HTTP POST or PUT variables your application sent to
	 * the REST API.
	 *
	 * @return Request variable string, or null
	 */
	public String getRequestVariables() {
		return getProperty("request_variables");
	}

	/**
	 * Only available in the Alert instance resource.
	 * If the Alert was generated by a request Twilio made to your server,
	 * this will be the HTTP headers returned by your server. Null otherwise.
	 *
	 * @return Response headers from your application to Twilio, or null.
	 */
	public String getResponseHeaders() {
		return getProperty("response_headers");
	}

	/**
	 * Only available in the Alert instance resource.
	 * If the Alert was generated by a request Twilio made to your server,
	 * this will be the HTTP body returned by your server. Null otherwise.
	 *
	 * @return Your application's response to a Twilio request, or null.
	 */
	public String getResponseBody() {
		return getProperty("response_body");
	}

	/**
	 * Delete this Alert from your Twilio account's logs.
	 *
	 * @return true, if successful
	 * @throws com.twilio.sdk.TwilioRestException the twilio rest exception
	 */
	public boolean delete() throws TwilioRestException {
		TwilioRestResponse response = getClient().safeRequest(
				getResourceLocation(), "DELETE", (Map) null);

		return !response.isError();
	}
}
