/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.taskrouter;

import com.twilio.sdk.TwilioTaskRouterClient;
import com.twilio.sdk.resource.NextGenInstanceResource;
import java.util.Date;
import java.util.Map;

public class Workflow
extends NextGenInstanceResource<TwilioTaskRouterClient> {
    private static final String WORKSPACE_SID_PROPERTY = "workspace_sid";

    public Workflow(TwilioTaskRouterClient client) {
        super(client);
    }

    public Workflow(TwilioTaskRouterClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    public Workflow(TwilioTaskRouterClient client, String workspaceSid, String workflowSid) {
        super(client);
        if (workspaceSid == null || "".equals(workspaceSid)) {
            throw new IllegalArgumentException("The workspaceSid for an Workflow cannot be null");
        }
        if (workflowSid == null || "".equals(workflowSid)) {
            throw new IllegalArgumentException("The workflowSid for an Workflow cannot be null");
        }
        this.setProperty(WORKSPACE_SID_PROPERTY, workspaceSid);
        this.setProperty("sid", workflowSid);
    }

    public String getAssignmentCallbackUrl() {
        return this.getProperty("assignment_callback_url");
    }

    public String getConfiguration() {
        return this.getProperty("configuration");
    }

    public Date getDateCreated() {
        return this.parseDate(this.getProperty("date_created"));
    }

    public Date getDateUpdated() {
        return this.parseDate(this.getProperty("date_updated"));
    }

    public String getFallbackAssignmentCallbackUrl() {
        return this.getProperty("fallback_assignment_callback_url");
    }

    public String getFriendlyName() {
        return this.getProperty("friendly_name");
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public String getTaskReservationTimeout() {
        return this.getProperty("task_reservation_timeout");
    }

    public String getWorkspaceSid() {
        return this.getProperty(WORKSPACE_SID_PROPERTY);
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Workspaces/" + this.getWorkspaceSid() + "/Workflows/" + this.getSid();
    }
}

