/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.taskrouter;

import com.twilio.sdk.TwilioTaskRouterClient;
import com.twilio.sdk.resource.NextGenInstanceResource;
import com.twilio.sdk.resource.instance.taskrouter.ActivityStatistic;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TaskQueueStatistics
extends NextGenInstanceResource<TwilioTaskRouterClient> {
    private static final String CUMULATIVE_PROPERTY = "cumulative";
    private static final String REALTIME_PROPERTY = "realtime";
    private static final String TASKS_BY_STATUS_PROPERTY = "tasks_by_status";
    private static final String TASK_QUEUE_SID_PROPERTY = "task_queue_sid";
    private static final String WORKSPACE_SID_PROPERTY = "workspace_sid";

    public TaskQueueStatistics(TwilioTaskRouterClient client, String workspaceSid, String queueSid) {
        this(client, workspaceSid, queueSid, null);
    }

    public TaskQueueStatistics(TwilioTaskRouterClient client, String workspaceSid, String queueSid, Map<String, String> filters) {
        this(client, workspaceSid, queueSid, filters, null);
    }

    public TaskQueueStatistics(TwilioTaskRouterClient client, String workspaceSid, String queueSid, Map<String, String> filters, Map<String, Object> properties) {
        super(client, properties);
        if (workspaceSid == null || "".equals(workspaceSid)) {
            throw new IllegalArgumentException("The workspaceSid for a TaskQueueStatistics cannot be null");
        }
        if (queueSid == null || "".equals(queueSid)) {
            throw new IllegalArgumentException("The queueSid for a TaskQueueStatistics cannot be null");
        }
        this.setProperty(WORKSPACE_SID_PROPERTY, workspaceSid);
        this.setProperty(TASK_QUEUE_SID_PROPERTY, queueSid);
        this.filters = filters;
    }

    public Set<ActivityStatistic> getActivityStatistics() {
        try {
            List props = (List)this.getRealtime().get("activity_statistics");
            HashSet<ActivityStatistic> activityStatistics = new HashSet<ActivityStatistic>();
            for (Map prop : props) {
                ActivityStatistic activityStatistic = this.mapToActivityStatistic(prop);
                activityStatistics.add(activityStatistic);
            }
            return Collections.unmodifiableSet(activityStatistics);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Integer getAssignedTasks() {
        Map tasksByStatus = (Map)this.getRealtime().get(TASKS_BY_STATUS_PROPERTY);
        return (Integer)tasksByStatus.get("assigned");
    }

    public Double getAverageTaskAcceptanceTime() {
        try {
            Object prop = this.getCumulative().get("avg_task_acceptance_time");
            if (prop instanceof Integer) {
                return Double.parseDouble(prop.toString());
            }
            return (Double)prop;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Calendar getEndTime() {
        return this.parseCalendar((String)this.getCumulative().get("start_time"));
    }

    public Integer getLongestTaskWaitingAge() {
        return (Integer)this.getRealtime().get("longest_task_waiting_age");
    }

    public String getLongestTaskWaitingSid() {
        return (String)this.getRealtime().get("longest_task_waiting_sid");
    }

    public Integer getPendingTasks() {
        Map tasksByStatus = (Map)this.getRealtime().get(TASKS_BY_STATUS_PROPERTY);
        return (Integer)tasksByStatus.get("pending");
    }

    public String getQueueSid() {
        return this.getProperty(TASK_QUEUE_SID_PROPERTY);
    }

    public Integer getReservationsAccepted() {
        return (Integer)this.getCumulative().get("reservations_accepted");
    }

    public Integer getReservationsRejected() {
        return (Integer)this.getCumulative().get("reservations_rejected");
    }

    public Integer getReservationsTimedOut() {
        return (Integer)this.getCumulative().get("reservations_timed_out");
    }

    public Integer getReservedTasks() {
        Map tasksByStatus = (Map)this.getRealtime().get(TASKS_BY_STATUS_PROPERTY);
        return (Integer)tasksByStatus.get("reserved");
    }

    public Calendar getStartTime() {
        return this.parseCalendar((String)this.getCumulative().get("start_time"));
    }

    public Integer getTasksCanceled() {
        return (Integer)this.getCumulative().get("tasks_canceled");
    }

    public Integer getTasksEntered() {
        return (Integer)this.getCumulative().get("tasks_entered");
    }

    public Integer getTasksMoved() {
        return (Integer)this.getCumulative().get("tasks_moved");
    }

    public Integer getTotalAvailableWorkers() {
        return (Integer)this.getRealtime().get("total_available_workers");
    }

    public Integer getTotalEligibleWorkers() {
        return (Integer)this.getRealtime().get("total_eligible_workers");
    }

    public Integer getTotalTasks() {
        return (Integer)this.getRealtime().get("total_tasks");
    }

    public String getWorkspaceSid() {
        return this.getProperty(WORKSPACE_SID_PROPERTY);
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Workspaces/" + this.getWorkspaceSid() + "/TaskQueues/" + this.getQueueSid() + "/Statistics";
    }

    private Map<String, Object> getCumulative() {
        return (Map)this.getObject(CUMULATIVE_PROPERTY);
    }

    private Map<String, Object> getRealtime() {
        return (Map)this.getObject(REALTIME_PROPERTY);
    }

    private ActivityStatistic mapToActivityStatistic(Map<String, Object> data) {
        Integer workers;
        String friendlyName;
        String sid;
        try {
            sid = (String)data.get("sid");
            friendlyName = (String)data.get("friendly_name");
            workers = (Integer)data.get("workers");
        }
        catch (Exception e) {
            throw new IllegalStateException("An Activity Statistic contained improperly formatted data.", e);
        }
        return new ActivityStatistic(sid, friendlyName, workers);
    }
}

