/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.InstanceResource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class Transcription
extends InstanceResource {
    private static final String SID_PROPERTY = "sid";

    public Transcription(TwilioRestClient client) {
        super(client);
    }

    public Transcription(TwilioRestClient client, String sid) {
        super(client);
        if (sid == null) {
            throw new IllegalStateException("The Sid for a Transcription can not be null");
        }
        this.setProperty(SID_PROPERTY, sid);
    }

    public Transcription(TwilioRestClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    @Override
    protected String getResourceLocation() {
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/Transcriptions/" + this.getSid() + ".json";
    }

    public String getSid() {
        return this.getProperty(SID_PROPERTY);
    }

    public Date getDateCreated() {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
        try {
            return format.parse(this.getProperty("date_created"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public Date getDateUpdated() {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
        try {
            return format.parse(this.getProperty("date_updated"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getStatus() {
        return this.getProperty("status");
    }

    public String getRecordingSid() {
        return this.getProperty("recording_sid");
    }

    public int getDuration() {
        return Integer.parseInt(this.getProperty("duration"));
    }

    public String getPrice() {
        return this.getProperty("price");
    }

    public String getTranscriptionText() {
        return this.getProperty("transcription_text");
    }

    public boolean delete() throws TwilioRestException {
        TwilioRestResponse response = this.getClient().safeRequest(this.getResourceLocation(), "DELETE", (Map<String, String>)null);
        return !response.isError();
    }
}

