/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.resource.InstanceResource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ConnectApp
extends InstanceResource {
    private static final String SID_PROPERTY = "sid";
    private static final String DATE_UPDATED_PROPERTY = "date_updated";
    private static final String DATE_CREATED_PROPERTY = "date_created";
    private static final String FRIENDLY_NAME_PROPERTY = "friendly_name";

    public ConnectApp(TwilioRestClient client) {
        super(client);
    }

    public ConnectApp(TwilioRestClient client, String sid) {
        super(client);
        if (sid == null) {
            throw new IllegalStateException("The Sid for a ConnectApp can not be null");
        }
        this.setProperty(SID_PROPERTY, sid);
    }

    public ConnectApp(TwilioRestClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    @Override
    protected String getResourceLocation() {
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/ConnectApps/" + this.getSid() + ".json";
    }

    public String getSid() {
        return this.getProperty(SID_PROPERTY);
    }

    public String getFriendlyName() {
        return this.getProperty(FRIENDLY_NAME_PROPERTY);
    }

    public Date getDateCreated() {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
        try {
            return format.parse(this.getProperty(DATE_CREATED_PROPERTY));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public Date getDateUpdated() {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
        try {
            return format.parse(this.getProperty(DATE_UPDATED_PROPERTY));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getDescription() {
        return this.getProperty("description");
    }

    public String getCompanyName() {
        return this.getProperty("company_name");
    }

    public String getHomepageUrl() {
        return this.getProperty("homepage_url");
    }

    public String getDeauthorizeCallbackUrl() {
        return this.getProperty("deauthorize_callback_url");
    }

    public String getAuthorizeRedirectUrl() {
        return this.getProperty("authorize_redirect_url");
    }

    public String getDeauthorizeCallbackMethod() {
        return this.getProperty("deauthorize_callback_method");
    }

    public List<String> getPermissions() {
        Object obj = this.getObject("permissions");
        return (List)obj;
    }
}

