/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.resource.InstanceResource;
import java.util.List;
import java.util.Map;

public class AuthorizedConnectApp
extends InstanceResource {
    private static final String SID_PROPERTY = "connect_app_sid";

    public AuthorizedConnectApp(TwilioRestClient client) {
        super(client);
    }

    public AuthorizedConnectApp(TwilioRestClient client, String sid) {
        super(client);
        if (sid == null) {
            throw new IllegalStateException("The Sid for an AuthorizedConnectApp can not be null");
        }
        this.setProperty(SID_PROPERTY, sid);
    }

    public AuthorizedConnectApp(TwilioRestClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    @Override
    protected String getResourceLocation() {
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/AuthorizedConnectApps/" + this.getSid() + ".json";
    }

    public String getSid() {
        return this.getProperty(SID_PROPERTY);
    }

    public String getConnectAppSid() {
        return this.getProperty(SID_PROPERTY);
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getFriendlyName() {
        return this.getProperty("connect_app_friendly_name");
    }

    public String getDescription() {
        return this.getProperty("connect_app_description");
    }

    public String getConnectAppDescription() {
        return this.getProperty("connect_app_description");
    }

    public String getConnectAppFriendlyName() {
        return this.getProperty("connect_app_friendly_name");
    }

    public String getCompanyName() {
        return this.getProperty("connect_app_company_name");
    }

    public String getConnectAppCompanyName() {
        return this.getProperty("connect_app_company_name");
    }

    public String getHomepageUrl() {
        return this.getProperty("connect_app_homepage_url");
    }

    public String getConnectAppHomepageUrl() {
        return this.getProperty("connect_app_homepage_url");
    }

    public List<String> getPermissions() {
        Object obj = this.getObject("permissions");
        return (List)obj;
    }
}

