/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk;

import com.twilio.sdk.AppEngineClientConnection;
import java.net.InetAddress;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.params.HttpParams;

public class AppEngineClientConnectionManager
implements ClientConnectionManager {
    private SchemeRegistry schemes;

    public AppEngineClientConnectionManager() {
        NoopSocketFactory noop_sf = new NoopSocketFactory();
        this.schemes = new SchemeRegistry();
        this.schemes.register(new Scheme("http", (SocketFactory)noop_sf, 80));
        this.schemes.register(new Scheme("https", (SocketFactory)noop_sf, 443));
    }

    public void closeExpiredConnections() {
    }

    public void closeIdleConnections(long idletime, TimeUnit tunit) {
    }

    public ManagedClientConnection getConnection(HttpRoute route, Object state) {
        return new AppEngineClientConnection(this, route, state);
    }

    public SchemeRegistry getSchemeRegistry() {
        return this.schemes;
    }

    public void releaseConnection(ManagedClientConnection conn, long valid, TimeUnit tuint) {
    }

    public ClientConnectionRequest requestConnection(final HttpRoute route, final Object state) {
        return new ClientConnectionRequest(){

            public void abortRequest() {
            }

            public ManagedClientConnection getConnection(long idletime, TimeUnit tunit) {
                return AppEngineClientConnectionManager.this.getConnection(route, state);
            }
        };
    }

    public void shutdown() {
    }

    class NoopSocketFactory
    implements SocketFactory {
        NoopSocketFactory() {
        }

        public Socket connectSocket(Socket sock, String host, int port, InetAddress addr, int lport, HttpParams params) {
            return null;
        }

        public Socket createSocket() {
            return null;
        }

        public boolean isSecure(Socket sock) {
            return false;
        }
    }
}

