/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.InstanceResource;
import com.twilio.sdk.resource.instance.Member;
import com.twilio.sdk.resource.list.MemberList;
import java.util.HashMap;
import java.util.Map;

public class Queue
extends InstanceResource {
    private static final String SID = "sid";
    private static final String FRIENDLY_NAME = "friendly_name";
    private static final String CURRENT_SIZE = "current_size";
    private static final String MAX_SIZE = "max_size";
    private static final String AVERAGE_WAIT_TIME = "average_wait_time";

    public Queue(TwilioRestClient client, String sid) {
        super(client);
        this.setProperty(SID, sid);
    }

    public Queue(TwilioRestClient client, Map<String, Object> params) {
        super(client, params);
    }

    public String getSid() {
        return this.getProperty(SID);
    }

    public String getFriendlyName() {
        return this.getProperty(FRIENDLY_NAME);
    }

    public int getCurrentSize() {
        Integer prop = (Integer)this.getObject(CURRENT_SIZE);
        if (prop != null) {
            return prop;
        }
        throw new IllegalStateException("The Queue instance doesn't have the current size property set");
    }

    public int getMaxSize() {
        Integer prop = (Integer)this.getObject(MAX_SIZE);
        if (prop != null) {
            return prop;
        }
        throw new IllegalStateException("The Queue instance doesn't have the max size property set");
    }

    public int getAverageWaitTime() {
        Integer prop = (Integer)this.getObject(AVERAGE_WAIT_TIME);
        if (prop != null) {
            return prop;
        }
        throw new IllegalStateException("The Queue instance doesn't have the average wait time property set");
    }

    public MemberList getMembers() {
        MemberList list = new MemberList(this.getClient(), this.getSid());
        list.setRequestAccountSid(this.getRequestAccountSid());
        return list;
    }

    public Member getMember(String callSid) {
        Member member = new Member(this.getClient(), this.getSid(), callSid);
        member.setRequestAccountSid(this.getRequestAccountSid());
        return member;
    }

    public Member dequeueHeadOfQueue(String url, String method) throws TwilioRestException {
        Member m = new Member(this.getClient(), this.getSid());
        m.setRequestAccountSid(this.getRequestAccountSid());
        return m.dequeue(url, method);
    }

    @Override
    protected String getResourceLocation() {
        return this.getBareResourceLocation() + ".json";
    }

    protected String getBareResourceLocation() {
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/Queues/" + this.getSid();
    }

    public void setFriendlyName(String friendlyName) throws TwilioRestException {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put(FRIENDLY_NAME, friendlyName);
        TwilioRestResponse response = this.getClient().safeRequest(this.getResourceLocation(), "POST", vars);
        if (response.isError()) {
            throw new IllegalStateException("Response indicated error:" + response.getResponseText());
        }
        this.setProperty(FRIENDLY_NAME, friendlyName);
    }

    public void setMaxSize(int maxSize) throws TwilioRestException {
        HashMap<String, String> vars = new HashMap<String, String>();
        String maxSizeString = Integer.toString(maxSize);
        vars.put(MAX_SIZE, maxSizeString);
        TwilioRestResponse response = this.getClient().safeRequest(this.getResourceLocation(), "POST", vars);
        if (response.isError()) {
            throw new IllegalStateException("Response indicated error:" + response.getResponseText());
        }
        this.setProperty(MAX_SIZE, maxSize);
    }
}

