/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.conversations;

import com.twilio.conversations.CallbackListener;
import com.twilio.conversations.Conversation;
import com.twilio.conversations.Disposable;
import com.twilio.conversations.Participant;
import com.twilio.util.TwilioLogger;
import java.util.List;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KClass;

final class Conversations
implements Disposable {
    private static final TwilioLogger logger = TwilioLogger.getLogger((KClass)JvmClassMappingKt.getKotlinClass(Conversations.class));
    private long nativeHandle;
    private boolean isDisposed = false;

    protected Conversations(long handle) {
        this.nativeHandle = handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Conversations conversations = this;
        synchronized (conversations) {
            this.checkDisposed("dispose");
            if (!this.isDisposed) {
                this.nativeDispose();
            }
            this.nativeHandle = 0L;
            this.isDisposed = true;
        }
    }

    private void checkDisposed(String method) {
        if (this.isDisposed) {
            logger.e("Attempt to use disposed object in Conversations#" + method);
        }
    }

    native void nativeCreateConversation(String var1, String var2, String var3, CallbackListener<Conversation> var4);

    native void nativeGetConversation(String var1, CallbackListener<Conversation> var2);

    native List<Conversation> nativeGetMyConversations();

    native List<Participant> nativeGetMembersByIdentity(String var1);

    native void nativeDispose();
}

